function bins = rank_hist(ens, verif)
%RANK_HIST: Computes a rank histogram given time series of ensemble and verification 

% Data Assimilation Research Testbed -- DART
% Copyright 2004-2007, Data Assimilation Research Section
% University Corporation for Atmospheric Research
% Licensed under the GPL -- www.gpl.org/licenses/gpl.html
%
% <next few lines under version control, do not edit>
% $URL: http://subversion.ucar.edu/DAReS/DART/trunk/matlab/rank_hist.m $
% $Id: rank_hist.m 2691 2007-03-11 18:18:09Z thoar $
% $Revision: 2691 $
% $Date: 2007-03-11 12:18:09 -0600 (Sun, 11 Mar 2007) $

% Determine how long the time series is
num_times = size(ens, 1);
ens_size = size(ens, 2);

% Need ens_size + 1 bins
bins(1:ens_size + 1) = 0.0;

% Loop through time series to get count for each bin
for i = 1:num_times
   count = 0;
   for j = 1:ens_size
      if verif(i) > ens(i, j)
         count = count + 1;
      end
   end
   bins(count+1) = bins(count+1) + 1;
end



