function [ Cp, Rd, gamma, Rv, L_c, g, T0, p0] = get_constants()
%
% Ideally, this would take netcdf filename as input, and
% read required constants from file.  At present, just a
% repository for hardwired constants.

% Data Assimilation Research Testbed -- DART
% Copyright 2004-2007, Data Assimilation Research Section
% University Corporation for Atmospheric Research
% Licensed under the GPL -- www.gpl.org/licenses/gpl.html
%
% <next few lines under version control, do not edit>
% $URL: http://subversion.ucar.edu/DAReS/DART/trunk/models/wrf/matlab/get_constants.m $
% $Id: get_constants.m 2691 2007-03-11 18:18:09Z thoar $
% $Revision: 2691 $
% $Date: 2007-03-11 12:18:09 -0600 (Sun, 11 Mar 2007) $

 %--Useful constants
 Rd = 287.0;
 Cp = 7.0*Rd/2.0;
 gamma = Cp / (Cp - Rd) ;
 Rv = 461; 
 g  = 9.81; 
 L_c = 2.25e6; 
 T0 = 300; 
 p0 = 1000.e2;
