function [y] = norm_pdf(x, mu, sigma)
%  computes a gaussian (normal) PDF
%  for the points of X with a given mean (mu) and standard deviation (sigma)
%
% normal plot, y given x:
%  y = (1 / (sigma * sqrt(2*pi))) * e ^ ((-1/2 * ((x-mu) / sigma)^2)
% or
%  g(x) = \frac{1}{\sigma\sqrt{2\pi}} e^{ -\frac{1}{2}\left(\frac{x-\mu}{\sigma}\right)^2 }.
%
% see: https://en.wikipedia.org/wiki/Probability_density_function

%% DART software - Copyright 2004 - 2013 UCAR. This open source software is
% provided by UCAR, "as is", without charge, subject to all terms of use at
% http://www.image.ucar.edu/DAReS/DART/DART_download
%
% DART $Id: norm_pdf.m 10127 2016-04-20 17:21:36Z thoar $

e = exp(1);

basen = (1.0 / (sigma * sqrt(2*pi)));
expon = -0.5 * (((x-mu) / sigma).^2 );

y = basen * (e .^ expon);

end

% <next few lines under version control, do not edit>
% $URL: https://proxy.subversion.ucar.edu/DAReS/DART/trunk/DART_LAB/matlab/private/norm_pdf.m $
% $Revision: 10127 $
% $Date: 2016-04-20 11:21:36 -0600 (Wed, 20 Apr 2016) $

