function corr = ens_correl(base_var, base_time, state_var)
% ens_correl  Computes correlation of a variable at a time to a time series of
% another variable (could be the same one)

% Data Assimilation Research Testbed -- DART
% Copyright 2004, Data Assimilation Initiative, University Corporation for Atmospheric Research
% Licensed under the GPL -- www.gpl.org/licenses/gpl.html 

% $Source: /home/thoar/CVS.REPOS/DART/matlab/ens_correl.m,v $
% $Revision: 1.4 $
% $Date: 2004/04/20 16:39:00 $

% Extract sample of base at base time

base_ens = base_var(base_time, :);

% size(base_var)
% size(base_time)
% size(state_var)
% size(base_ens)

% Loop through time to correlate with the other ensemble series
num_times = size(state_var, 1);
for i = 1:num_times
   x = corrcoef(base_ens, state_var(i, :));
   corr(i) = x(1, 2);
end 
