function height = compute_height( phi, g )
%
% Inputs:
%	phi = (full) geopotential, at w pts
%	g   = gravitational acceleration
% Output:
%	height = height, at mass pts
%

% Data Assimilation Research Testbed -- DART
% Copyright 2004, 2005, Data Assimilation Initiative, University Corporation for Atmospheric Research
% Licensed under the GPL -- www.gpl.org/licenses/gpl.htm

% <next three lines automatically updated by CVS, do not edit>
% $Id: compute_height.m,v 1.1 2005/10/13 17:13:51 thoar Exp $
% $Source: /home/thoar/CVS.REPOS/DART/models/wrf/matlab/compute_height.m,v $
% $Name: pre_iceland $

height = ( phi(2:end,:,:) + phi(1:end-1,:,:) ) ./ (2*g) ;
