#### subset and re-order
 cnt.id <- match(cnt.nms, NMS.short)
 sub.id <- match(mod.nms, NMS.short)
all.nms <- c(cnt.nms, mod.nms)
new.ord <- c(cnt.id, sub.id)
  n.mod <- length(new.ord)

#### Input data
VVV <- OUT.crps
titl <- paste(var.char1, "_", round(level[P]/100), "mb", sep="")

#### Threshold
if(between){
   rang <- paste("( ",Q1," < Q < ",Q2," )",sep="")
}else{
   if(Q >= 0.50){
    rang <- paste("( Q > ",Q," )",sep="")
   }else{
    rang <- paste("( Q < ",Q," )",sep="")
   }
}

#### 
TEMP <- NULL

for(j in 1:n.mod){
	
temp <- VVV[[new.ord[j]]]	
OUT <- matrix(NA, nrow = length(temp), ncol = length(temp[[1]]))

for(i in 1:length(temp)){
	OUT[i,] <- temp[[i]] }	## close i	
	
#### 
OUT2 <- NULL

for( i in 1:6){  ## loop on lead times
	temp <- data.frame(lead = time[i], val = OUT[,i])
	OUT2 <- rbind(OUT2, temp)
	}  ## close i

x <- data.frame(run = NMS.short[new.ord[j]], OUT2)
TEMP <- rbind(TEMP, x)
	}  ## close j

xx <- levels(TEMP$run)
yy <- xx[match(all.nms, xx)]
TEMP$run <- factor(TEMP$run, levels = yy)

xx <- aggregate(TEMP$val, by = list(run = TEMP$run, lead = TEMP$lead), quantile, 0.05)
yy <- aggregate(TEMP$val, by = list(run = TEMP$run, lead = TEMP$lead), quantile, 0.95)
zz <- aggregate(TEMP$val, by = list(run = TEMP$run, lead = TEMP$lead), mean)
X  <-  data.frame(xx[,1:2], min = xx$x, max = yy$x, mean = zz$x)

#### spaceing

X$space <- seq(-4,4, length = n.mod)
X$plot.point <- X$lead + X$space

a <- min(X$min)
b <- max(X$max)

Cont <- TEMP[TEMP$run == cnt.nms, "val"]
RUNS <- TEMP[TEMP$run != cnt.nms, ]

RUNS$cont <- Cont
RUNS$diff <- RUNS$cont - RUNS$val  

xx <- aggregate(RUNS$diff, by = list(run = RUNS$run, lead = RUNS$lead), quantile, 0.05)
yy <- aggregate(RUNS$diff, by = list(run = RUNS$run, lead = RUNS$lead), quantile, 0.95)
zz <- aggregate(RUNS$diff, by = list(run = RUNS$run, lead = RUNS$lead), mean)
X <-  data.frame(xx[,1:2], min = xx$x, max = yy$x, mean = zz$x, space = rep(seq(-2,2, length = n.mod - 1), times = 6))

#### spaceing

X$plot.point <- X$lead + X$space

a <- min(X$min)
b <- max(X$max)

########## reliability diagrams

if(TRUE){ ### reliability plot

ALL<- matrix(NA, nrow = n.mod*6, ncol = 13)
ALL <- as.data.frame(ALL)
indx <- 1
for(j in 1:n.mod){ ### model loop

ii <- new.ord[j]

for(k in 1:6){ # lead loop
X<- NULL

for( i in 1:n.boot){
dat <- OUT.attr[[ii]][[i]]

LDS <- unique(dat$lead)

sub <- dat[dat$lead == LDS[k], ]

x1 <- table(sub$obs, sub$prob.frcst)
x2 <- table(sub$prob.frcst)
x3 <- as.numeric(colnames(x1) )

oi <- x1[2,]/x2

temp <- cbind(frcst = x3, obari = oi)
X <- rbind(X, temp)

}  ## close i

X <- as.data.frame(X)

### save for overlay plot

MM <- aggregate(X$obari, by = list(frcst = X$frcst), median)
ALL[indx, 1] <- NMS.short[ii]
ALL[indx, 2] <- time[k]
ALL[indx, -c(1,2)] <- MM$x
indx <- indx + 1

}  ## close lead loop k
} ### close model loop j 

pdf(paste(fig.dir, "relib.48h.bw.", var.char1,  round(level[P]/100),"mb", ".pdf", sep = ""),  width = 3.33, height = 3.33, paper = "special", pointsize = 10 )

par(mar = c(3.5,3.5,0.5,0.5), mfrow = c(1,1), oma = c(0,0,0,0))

for( i in c(5)){
	
	sub <- ALL[ALL$V2 == time[i],]
         #matplot(t(sub[,-c(1,2)]), type = "l", lty = c(1,2,4), lwd =3,
	 matplot(t(sub[,-c(1,2)]), type = "b", lty = 1, pch = PCH2, lwd =2, cex = 1.0, #bg = "white",
                 col = 1, ylim = c(0,1), ylab = "", xlab ="",
                 axes = FALSE) # main = paste("Lead = ", time[i], "hr") ) 
	 abline(-.1,0.1)
	 axis(1, at = seq(1,11), label = seq(0,1,0.1))
	 box()
	 axis(2, las = 1)
	 
	mtext( "Cond. Obs. Freq.", side = 2, line = 2.5)
	mtext( "Forecast", side = 1, line = 2)
}
	
dev.off()

}
##########
