#!/bin/csh

# hpss2restart.csh
# script for copying 1 day/obs_seq of restart files from the HPSS.
# CAM, CLM, CICE and possibly filter_ic for each ensemble member are grouped together
# so that we can retrieve a subset of the ensemble members for a new experiment.
# Each batch has several ensemble member groups.

setenv LD_LIBRARY_PATH ${LD_LIBRARY_PATH}:/usr/local/dcs/lib
echo $LD_LIBRARY_PATH

# set  echo verbose

if ($#argv < 3) then
   echo "usage: from case/experiment/obs_seq directory; "
   echo "       hpss2restart.csh HSIpathname(no file name) batch1_number batchn_number uncompress(optnl)"
   echo "       untars ensemble members and puts them where they belong."
   echo "       Uncompresses CAM, CLM, and CICE files, if told to."
   echo "       The POP_force restart sets are not compressed."
   exit
endif

set ms_root = $1
set ms_dir = $ms_root

hsi ls -l $ms_root
if ($status == 0) then
   echo "files will be read from $ms_root/batch#"
else
   echo "$ms_root does not exist.  Check name and try again"
   exit
endif

set uncomp = false
if ($#argv == 4) set uncomp = true

set batchn = $3
set batch = $2

while($batch <= $batchn)

   echo "fetching ${ms_dir}/batch${batch}"
   if ($uncomp == true) then
      # msrcp ${ms_dir}/batch${batch}.cmp batch$batch
      hsi get batch$batch : ${ms_dir}/batch${batch}.cmp
   else
      # msrcp ${ms_dir}/batch$batch .
      hsi get batch$batch : ${ms_dir}/batch$batch
   endif

#  This makes CAM CLM CICE DART directories, as necessary, to place its files.
   echo "untarring"
   tar -x -f batch$batch
   rm batch$batch
   @ batch++
end

if ($uncomp == true) then
   gunzip -r CAM
   gunzip -r CLM
endif

echo "hsi get done; check local files "

exit
