"Snackbar.test" <- 
function()
{
	ecode <- 0
	# define a multidimensional array (2 x 3 x 4) and then parse
	# it into a series of (2 x 3) matrices. The elements of the 
	# matrices are the row,column indices -- preceeded by which
	# matrix they are ... so element 2,1 of matrix 3 has a value
	# of 321, element 1,1  has a value of 311, and so on.
	NDarray <- array(c(111, 121, 112, 122, 113, 123, 211, 221, 212, 222,
		213, 223, 311, 321, 312, 322, 313, 323, 411, 421, 412, 422,
		413, 423), c(2, 3, 4))
	dims <- dim(NDarray)
	nrows <- dims[1]
	ncols <- dims[2]
	#------------------------------------------------------------
	# parse the N-dimensional array into a few matrices.
	#------------------------------------------------------------
	a <- NDarray[,  , 1]
	b <- NDarray[,  , 2]
	d <- NDarray[,  , 3]
	#------------------------------------------------------------
	# Create the file Flat.ieee ...
	#------------------------------------------------------------
	cat("\n Testing flat.write \n", fill = T)
	f1 <- flat.write(c(nrows, ncols), "Flat.ieee", ioflag = 2, type = 
		"integer")
	f2 <- flat.write(a, "Flat.ieee", ioflag = 3)
	f3 <- flat.write(b, "Flat.ieee", ioflag = 3, type = "real*8")
	f4 <- flat.write(d, "Flat.ieee", ioflag = 4, type = "integer")
	if(f1 != 2) {
		cat("ERROR in first  record of flat.write", fill = T)
		ecode <- -1
		exit
	}
	else {
		cat("flat.write first  record right size", fill = T)
	}
	if(f2 != 6) {
		cat("ERROR in second record of flat.write", fill = T)
		ecode <- -2
		exit
	}
	else {
		cat("flat.write second record right size", fill = T)
	}
	if(f3 != 6) {
		cat("ERROR in third  record of flat.write", fill = T)
		ecode <- -3
		exit
	}
	else {
		cat("flat.write third  record right size", fill = T)
	}
	if(f4 != 6) {
		cat("ERROR in fourth record of flat.write", fill = T)
		ecode <- -4
		exit
	}
	else {
		cat("flat.write fourth record right size", fill = T)
	}
	#------------------------------------------------------------
	# Read the file Flat.ieee ...
	#------------------------------------------------------------
	cat("\n Testing flat.read \n", fill = T)
	z <- flat.read("Flat.ieee", 1, 2, ioflag = 2, type = "integer")
	if(sum(z - c(2, 3)) != 0) {
		cat("ERROR in (flat.[read,write]) with first record ...", fill
			 = T)
		cat("Did not read the matrix dimensions properly.", fill = T)
		cat(paste("supposed to read [2 3] and read [", as.character(
			z[1]), as.character(z[2]), "]"), fill = T)
		ecode <- -5
		exit
	}
	A <- flat.read("Flat.ieee", z[1, 1], z[1, 2], ioflag = 3)
	B <- flat.read("Flat.ieee", z[1, 1], z[1, 2], ioflag = 3, type = 
		"real*8")
	D <- flat.read("Flat.ieee", z[1, 1], z[1, 2], ioflag = 4, type = 
		"integer")
	#------------------------------------------------------------
	# Compare what was read to the truth ...
	#------------------------------------------------------------
	t1sum <- sum(A - a)
	t2sum <- sum(B - b)
	t3sum <- sum(D - d)
	if(t1sum == 0) {
		cat("flat.[read,write] for 32bit reals works OK ...", fill = T)
	}
	else {
		cat("ERROR in (flat.[read,write]) for 32bit reals ...", fill = 
			T)
		cat("Functions not working properly.", fill = T)
		ecode <- -6
		exit
	}
	if(t2sum == 0) {
		cat("flat.[read,write] for 64bit reals works OK ...", fill = T)
	}
	else {
		cat("ERROR in (flat.[read,write]) for 64bit reals ...", fill = 
			T)
		cat("Functions not working properly.", fill = T)
		ecode <- -7
		exit
	}
	if(t3sum == 0) {
		cat("flat.[read,write] for integers works OK ...", fill = T)
	}
	else {
		cat("ERROR in (flat.[read,write]) for integers ...", fill = T)
		cat("Functions not working properly.", fill = T)
		ecode <- -8
		exit
	}
	#------------------------------------------------------------
	# Now work on the Direct-access portion -- writing
	#------------------------------------------------------------
	cat("\n Testing direct.write \n", fill = T)
	da <- direct.write("daR4.ieee", NDarray)
	db <- direct.write("daR8.ieee", NDarray, type = "real*8")
	dc <- direct.write("daI4.ieee", NDarray, type = "integer")
	cat(paste("Direct Access R4 write returned ", as.character(da), 
		" supposed to be 24"), fill = T)
	cat(paste("Direct Access R8 write returned ", as.character(db), 
		" supposed to be 24"), fill = T)
	cat(paste("Direct Access I4 write returned ", as.character(dc), 
		" supposed to be 24"), fill = T)
	#------------------------------------------------------------
	# Now work on Direct-access -- test 1 -- reading big blocks
	#------------------------------------------------------------
	cat("\n Test 1 of direct.read -- reading big blocks \n", fill = T)
	A <- direct.read("daR4.ieee", reclen = 2 * 3 * 4, rec1 = 1, type = 
		"real")
	B <- direct.read("daR8.ieee", reclen = 2 * 3 * 4, rec1 = 1, type = 
		"real*8")
	D <- direct.read("daI4.ieee", reclen = 2 * 3 * 4, rec1 = 1, type = 
		"integer")
	t1sum <- sum(A - array(NDarray, c(2 * 3 * 4, 1)))
	t2sum <- sum(B - array(NDarray, c(2 * 3 * 4, 1)))
	t3sum <- sum(D - array(NDarray, c(2 * 3 * 4, 1)))
	cat(paste("t1sum = ", as.character(t1sum)), fill = T)
	cat(paste("t2sum = ", as.character(t2sum)), fill = T)
	cat(paste("t3sum = ", as.character(t3sum)), fill = T)
	if(t1sum == 0) {
		cat("test 1:direct.[read,write] for 32bit reals works OK ...",
			fill = T)
	}
	else {
		cat("ERROR in (direct.[read,write]) for 32bit reals ...", fill
			 = T)
		cat("Functions not working properly.", fill = T)
		ecode <- -9
		exit
	}
	if(t2sum == 0) {
		cat("test 1:direct.[read,write] for 64bit reals works OK ...",
			fill = T)
	}
	else {
		cat("ERROR in (direct.[read,write]) for 64bit reals ...", fill
			 = T)
		cat("Functions not working properly.", fill = T)
		ecode <- -10
		exit
	}
	if(t3sum == 0) {
		cat("test 1:direct.[read,write] for integers works OK ...",
			fill = T)
	}
	else {
		cat("ERROR in (direct.[read,write]) for integers ...", fill = T
			)
		cat("Functions not working properly.", fill = T)
		ecode <- -11
		exit
	}
	#------------------------------------------------------------
	# Now work on Direct-access -- test 2 -- random reads
	#------------------------------------------------------------
	cat("\n Test 2 of direct.read -- reading random records \n", fill = T)
	A <- direct.read("daR4.ieee", reclen = 2 * 3, rec1 = 1, type = "real")
	B <- direct.read("daR8.ieee", reclen = 2 * 3, rec1 = 2, type = "real*8"
		)
	D <- direct.read("daI4.ieee", reclen = 2 * 3, rec1 = 3, type = 
		"integer")
	t1sum <- sum(a - array(A, c(2, 3)))
	t2sum <- sum(b - array(B, c(2, 3)))
	t3sum <- sum(d - array(D, c(2, 3)))
	if(t1sum == 0) {
		cat("test 2:direct.[read,write] for 32bit reals works OK ...",
			fill = T)
	}
	else {
		cat("ERROR in (direct.[read,write]) for 32bit reals ...", fill
			 = T)
		cat("Functions not working properly.", fill = T)
		ecode <- -12
		exit
	}
	if(t2sum == 0) {
		cat("test 2:direct.[read,write] for 64bit reals works OK ...",
			fill = T)
	}
	else {
		cat("ERROR in (direct.[read,write]) for 64bit reals ...", fill
			 = T)
		cat("Functions not working properly.", fill = T)
		ecode <- -13
		exit
	}
	if(t3sum == 0) {
		cat("test 2:direct.[read,write] for integers works OK ...",
			fill = T)
	}
	else {
		cat("ERROR in (direct.[read,write]) for integers ...", fill = T
			)
		cat("Functions not working properly.", fill = T)
		ecode <- -14
		exit
	}
	#------------------------------------------------------------
	# Now work on Direct-access -- test 3 -- multiple records
	# Not supported in current version.
	#------------------------------------------------------------
	cat("\n Test 3 of direct.read -- reading multiple records \n", fill = T
		)
	A <- direct.read("daR4.ieee", reclen = 2 * 3, rec1 = 1, recN = 2, type
		 = "real")
	B <- direct.read("daR8.ieee", reclen = 2 * 3, rec1 = 2, recN = 3, type
		 = "real*8")
	D <- direct.read("daI4.ieee", reclen = 2 * 3, rec1 = 3, recN = 4, type
		 = "integer")
	t1sum <- sum(A - array(NDarray[,  , 1:2], c(6, 2)))
	t2sum <- sum(B - array(NDarray[,  , 2:3], c(6, 2)))
	t3sum <- sum(D - array(NDarray[,  , 3:4], c(6, 2)))
	if(t1sum == 0) {
		cat("test 3:direct.[read,write] for 32bit reals works OK ...",
			fill = T)
	}
	else {
		cat("ERROR in (direct.[read,write]) for 32bit reals ...", fill
			 = T)
		cat("Functions not working properly.", fill = T)
		ecode <- -15
		exit
	}
	if(t2sum == 0) {
		cat("test 3:direct.[read,write] for 64bit reals works OK ...",
			fill = T)
	}
	else {
		cat("ERROR in (direct.[read,write]) for 64bit reals ...", fill
			 = T)
		cat("Functions not working properly.", fill = T)
		ecode <- -16
		exit
	}
	if(t3sum == 0) {
		cat("test 3:direct.[read,write] for integers works OK ...",
			fill = T)
	}
	else {
		cat("ERROR in (direct.[read,write]) for integers ...", fill = T
			)
		cat("Functions not working properly.", fill = T)
		ecode <- -17
		exit
	}
	if(ecode == 0) {
		cat("Snackbar OK", fill = T)
	}
	return(ecode)
}

