"direct.write" <- 
function(file, NDarray, unit = 85, type = "real")
{
	#-----------------------------------------------------------------------
	#
	# This writes miltidimensional arrays into 
	# Fortran direct-access binary records.
	#
	# USAGE:
	#
	# directwrite(filename, NDarray, unit, type)
	#
	#     filename		chacter string
	#     NDarray           the data array
	#     unit		The Fortran unit for reading [default is 95]
	#     type		Data type -- INTEGER, REAL, REAL*8
	#
	#
	# IMPORTANT: If you have multiple files open (for reading or writing), 
	#            YOU had best keep track of which unit is which file.
	#            Lying will be produce undesirable results, guaranteed.
	#
	# EQUALLY IMPORTANT: writing mixed-length arrays to the same file
	#            is guaranteed to make you regret it later ...
	#            (not that I'm letting you do that right now ...)
	#
	#-----------------------------------------------------------------------
	cherr <- "                                        "
	dims <- dim(NDarray)
	reclen <- prod(dims)
	irec <- 1
	type <- tolower(type)
	if(type == tolower("real*8")) {
		datalist <- .Fortran("ddirectwrite",
			file = as.character(file),
			unit = as.integer(unit),
			reclen = as.integer(reclen),
			irec = as.integer(irec),
			x = as.double(NDarray),
			ierr = integer(length = 1),
			cherr = as.character(paste(cherr, cherr)))
	}
	else if(type == tolower("integer")) {
		datalist <- .Fortran("idirectwrite",
			file = as.character(file),
			unit = as.integer(unit),
			reclen = as.integer(reclen),
			irec = as.integer(irec),
			x = as.integer(NDarray),
			ierr = integer(length = 1),
			cherr = as.character(paste(cherr, cherr)))
	}
	else {
		datalist <- .Fortran("directwrite",
			file = as.character(file),
			unit = as.integer(unit),
			reclen = as.integer(reclen),
			irec = as.integer(irec),
			x = as.single(NDarray),
			ierr = integer(length = 1),
			cherr = as.character(paste(cherr, cherr)))
	}
	if(datalist$ierr == -1) {
		print(paste("ERROR:Unable to open input file", datalist$file))
		print(datalist$cherr)
	}
	else if(datalist$ierr == -2) {
		print(paste("ERROR:Unable to read input file", datalist$file))
		print(datalist$cherr)
	}
	else if(datalist$ierr == -3) {
		print(paste("ERROR:Early end of input file", datalist$file))
		print(datalist$cherr)
	}
	else {
		print(paste("Wrote", as.character(datalist$ierr), "items."))
		return(datalist$ierr)
	}
}
