"flat.read" <- 
function(file, numrow, numcol, rec1 = 1, recN = 1, ioflag = 3, unit = 96, type
	 = "real")
{
	#-----------------------------------------------------------------------
	#
	# This reads Fortran unformatted binary records 
	# into a matrix. 2D Matrices are handled naturally, other
	# shapes/sizes are best treated as Nx1 matrices, where N is
	# the product of the dimensions.
	#
	# USAGE:
	#
	# flatread(file, numrow, numcol, rec1, recN, ioflag, unit, type)
	#
	#     file		chacter string
	#     numrow		leading dimension of binary file (# of rows)
	#     numcol		second  dimension of binary file (# of cols)
	#     rec1		first (relative to current position) matrix to return
	#     recN		last  (relative to current position) matrix to return
	#     ioflag == 1       open, read and close the file
	#     ioflag == 2       open, read, and leave the file open
	#     ioflag == 3       read and leave the file open
	#     ioflag == 4       read and close the file
	#     unit		The Fortran unit for reading
	#     type		Data type -- INTEGER, REAL, REAL*8
	#
	#-----------------------------------------------------------------------
	cherr <- "                                        "
	if((recN == 1) & (rec1 > 1)) {
		recN <- rec1
	}
	xlen <- numrow * numcol * (recN - rec1 + 1)
	type <- tolower(type)
	if(type == tolower("real*8")) {
		datalist <- .Fortran("dflatread",
			file = as.character(file),
			unit = as.integer(unit),
			nrows = as.integer(numrow),
			ncols = as.integer(numcol),
			rec1 = as.integer(rec1),
			recN = as.integer(recN),
			x = double(xlen),
			fcode = as.integer(ioflag),
			ierr = integer(length = 1),
			cherr = as.character(paste(cherr, cherr)))
	}
	else if(type == tolower("integer")) {
		datalist <- .Fortran("iflatread",
			file = as.character(file),
			unit = as.integer(unit),
			nrows = as.integer(numrow),
			ncols = as.integer(numcol),
			rec1 = as.integer(rec1),
			recN = as.integer(recN),
			x = integer(xlen),
			fcode = as.integer(ioflag),
			ierr = integer(length = 1),
			cherr = as.character(paste(cherr, cherr)))
	}
	else {
		datalist <- .Fortran("flatread",
			file = as.character(file),
			unit = as.integer(unit),
			nrows = as.integer(numrow),
			ncols = as.integer(numcol),
			rec1 = as.integer(rec1),
			recN = as.integer(recN),
			x = single(xlen),
			fcode = as.integer(ioflag),
			ierr = integer(length = 1),
			cherr = as.character(paste(cherr, cherr)))
	}
	if(datalist$ierr == -1) {
		print(paste("ERROR:Unable to open input file", datalist$file))
		print(datalist$cherr)
	}
	else if(datalist$ierr == -2) {
		print(paste("ERROR:Unable to read input file", datalist$file))
		print(datalist$cherr)
	}
	else if(datalist$ierr == -3) {
		print(paste("ERROR:Early end of input file", datalist$file))
		print(datalist$cherr)
	}
	else {
		print(paste("Read", as.character(datalist$ierr), "items."))
	}
	#       print(datalist$file)
	#       print(paste("Number of rows is",as.character(datalist$nrows)))
	#       print(paste("Number of cols is",as.character(datalist$ncols)))
	#       print(paste("File handler flag",as.character(datalist$length(fcode))))
	if(rec1 == recN) {
		matrix(datalist$x, nrow = numrow)
	}
	else {
		array(datalist$x, dim = c(numrow, numcol, recN - rec1 + 1))
	}
}

