"flat.write" <- 
function(datmat, file, ioflag = 3, miss = -999., unit = 95, type = "real")
{
	#-------------------------------------------------------------------------------
	# This writes an IEEE Fortran unformatted binary file.
	#
	# flatwrite(datmat,file,ioflag,miss,unit,type)
	#
	# datmat	the list (usually a multidimensional array)
	# file		the complete file name for the output
	# ioflag		the open/close switch
	#		== 1 -> open, write, close
	#		== 2 -> open, write, leave open
	#		== 3 -> already open, write, leave open [default]
	#		== 4 -> already open, write, close
	# miss		replace NA with <miss>
	# unit		The Fortran unit for writing
	# type		The Fortran data type: INTEGER, REAL, REAL*8
	#
	# RETURNS:	the number of data written to the file
	#
	#-------------------------------------------------------------------------------
	# Simply replace the NA's with the missing value flag ...

#if( !is.matrix(datmat)) datmat<- matrix( datmat, ncol=1)

	newarr <- array(datmat)
        arrlen <- length(newarr)
	inds   <- seq(1:arrlen)[is.na(newarr)]
	newarr[inds] <- miss
	#       print(file)
	#       print(paste("Number of elems is",as.character(arrlen)))
	#       print(paste("Missing flag   is",as.character(miss)))
	#       print(paste("# of missing data",as.character(length(inds))))
	#       print(paste("File handler flag",as.character(length(ioflag))))
	cherr <- "                                        "
	dtype <- tolower(type)
	if(dtype == tolower("real*8")) {
		rval <- .Fortran("dflatwrite",
			file = as.character(file),
			unit = as.integer(unit),
			nlen = as.integer(arrlen),
			data = as.double(newarr),
			ioflag = as.integer(ioflag),
			ndata = integer(length = 1),
			cherr = as.character(paste(cherr, cherr)))
	}
	else if(dtype == tolower("integer")) {
		rval <- .Fortran("iflatwrite",
			file = as.character(file),
			unit = as.integer(unit),
			nlen = as.integer(arrlen),
			data = as.integer(newarr),
			ioflag = as.integer(ioflag),
			ndata = integer(length = 1),
			cherr = as.character(paste(cherr, cherr)))
	}
	else {
		rval <- .Fortran("flatwrite",
			file = as.character(file),
			unit = as.integer(unit),
			nlen = as.integer(arrlen),
			data = as.single(newarr),
			ioflag = as.integer(ioflag),
			ndata = integer(length = 1),
			cherr = as.character(paste(cherr, cherr)))
	}
	if(rval$ndata == -1) {
		print(paste("ERROR:Unable to open output file", file))
		print(rval$cherr)
	}
	else if(rval$ndata == -2) {
		print(paste("ERROR:Unable to write to file", file))
		print(rval$cherr)
	}
	else {
		print(paste("Wrote", as.character(rval$ndata), "observations.")
			)
	}
	return(rval$ndata)
}
