\name{direct.read}
\alias{direct.read}
\author{Tim Hoar \email{thoar@ucar.edu} \url{http://www.cgd.ucar.edu/~thoar} }
\title{Fortran "direct-access" read}
\description{
  reads Fortran "direct-access" binary records into R objects.
}
\synopsis{
   direct.read(file=NULL, reclen=NULL, rec1=1, recN=rec1,
                 unit=86, type="real")
}
\usage{
   direct.read(file, reclen=1, rec1=1, recN=23)
   direct.read(file, reclen=100, rec1=10, type="integer")
}

\arguments{

   \item{file}{The file name.}

   \item{reclen}{The number of words in each Fortran binary record.}

   \item{rec1}{[optional] which Fortran record (data chunk) to start reading [default is 1].}
   \item{recN}{[optional] last Fortran record to read defaults to value of rec1}

   \item{unit}{[optional] integer to describe the Fortran unit. This is only
   needed if you intend to read/write from multiple files simultaneously.
   Fortran associates a file with a unique (hopefully) integer and uses
   the integer for everything.  Stay away from unit == 5, unit == 6,
   which can have special meaning./cr
   unit == 86 [default]}

   \item{type}{[optional] character string to describe the Fortran variable
   type.\cr
   type == "real" [default]\cr
   type == "real*8"\cr
   type == "integer"}
}

\details{
   Fortran direct-access records need not be read in a sequential 
   fashion, so you simply need to supply the file name, the record size 
   (by definition, all records are the same length), and which record you 
   want to read.\cr

   This works best when you tell it the truth .... the record size
   should match how the file was created.  Cleverly lying may produce
   desirable results, poor lying will produce poor results.\cr

   Fortran direct-access files MUST be written with a single record length.\cr

   \emph{IMPORTANT} If you have multiple files open (for reading or writing),
   \emph{you} had best keep track of which unit is which file. Doing otherwise is
   going to produce undesirable results, guaranteed.

}

\examples{
# Create some data and
# write it out as 32 bit "reals" ...
# and read it back in again ...
#
   datmat <- array(c(111,121,112,122,113,123,
                     211,221,212,222,213,223,
                     311,321,312,322,313,323,
                     411,421,412,422,413,423),c(2,3,4))
   A <- direct.write("daR4.ieee", datmat)
   Z <- direct.read("daR4.ieee", reclen = 2*3*4, type="real")
#
# Now, lets think of the file as containing four separate 2-by-3 matrices
# (fundamentally four records of 2-by-3 matrices) ... and lets just read
# the second matrix without reading anything else ...
#
A2 <- direct.read("daR4.ieee", reclen = 6, rec1 = 2)
A2
#   211 212 213
#   221 222 223
#
#  datmat[,,2]
}

\note{
   Because there is no record information (inherently) it is possible
   to read garbage. If you think you are reading 32 bit items and they
   are really 64bit, for example, you are guaranteed to get garbage.
   Similarly, if you are mistaken about the record size. If the file was
   written with records of length 1000 and you think they are length 100,
   garbage will result (for anything past element 100).
}

\seealso{ \code{\link{direct.write}, \link{flat.read}, \link{flat.write} } }

\value{
   \item{An array of dimension [reclen,recN-rec1+1] }
}
\keyword{IO}
