\name{getncvar}
\alias{getncvar}
\title{GETNCVAR: Import a netCDF variable}
\description{
  Imports a netCDF variable 
}
\synopsis{
   getncvar(filename=NULL, varname=NULL)
}
\usage{
   getncvar(filename)
   getncvar(filename, varname)
}

\arguments{

   \item{filename}{The netCDF file name.}

   \item{varname}{A variable in the netCDF file.}

}
\value{
   A list containing six components.

   \item{\emph{filename}}

   \item{\emph{varname} The "short" variable name as it is in the netCDF file.}

   \item{\emph{shape} The dimensionality of the variable.}

   \item{\emph{x} The datastream. Returned as a proper N-dimensional "array". 
   WARNING: netCDF variables can be HUGE. If you try to read a HUGE variable, 
   you will GET a HUGE variable. Then what will you do ...}

   \item{\emph{ierr} The error code. Should be identically zero.}

   \item{\emph{cherr} The error message. Only used if ierr is not zero.}

   so if the filename is HolyMackerel.nc ... and the interesting variable is
   "catch" ... the following would be the way to go:\cr

   fish <- getncvar("HolyMackerel.nc","catch")\cr
   catch <- fish\$x
}

\details{NetCDF files are tricky things. They can be HUGE, so make sure you know the
dimensions of the variable you are trying to extract. If you are unsure,
simply use getncvar with only a filename and it will report the dimensions
of all variables in the file.\cr

At present, there is no ability to subset the variable in the call. Some of
the more clever widgets for accessing netCDF files allow that and more. I
simply don't have the time to implement that. I also do not have any time
to implement an "output" widget. I know of no way to write a netCDF file
from S-PLUS.\cr

The basis for this function is a set of (Fortran) library routines publicly
available from Unidata.}
\example{ }
\note{ }
\seealso{ }

\keyword{IO}
