      subroutine ddirectwrite(filename,nunit,reclen,irec,datvec,
     &              ierr,cherr)
C-----------------------------------------------------------------------
C --- Direct access writes are easier than unformatted. Since they
C --- are "random access", you can open/close the file at will and
C --- not lose any generality. The record length is fixed, however,
C --- and there is no way to check if you are writing where you think 
C --- you are writing.
C-----------------------------------------------------------------------

      implicit none

      character*256	filename		! the filename, duh
      integer		nunit			! Fortran unit
      integer		reclen			! items in a record
      integer		irec			! which record
      real*8		datvec(reclen)		! data vector
      integer		ierr			! error code
      character*80	cherr			! error string

C --- ------------------------------------------------------------------
C --- Do Something
C --- ------------------------------------------------------------------

      open(nunit,file=filename,status='unknown',access='direct',
     &                  recl=reclen*8,err=900)
      rewind(nunit)
      write(nunit,rec=irec,err=901)datvec
      close(nunit,err=902)
      ierr = reclen
      goto 999

 900  ierr = -1
      cherr = "ERROR(ddirectwrite): unable to open input file "
      goto 999

 901  ierr = -2
      cherr = "ERROR(ddirectwrite): unable to write record "
      goto 999

 902  ierr = -3
      cherr = "ERROR(ddirectwrite): unable to close file. "
      goto 999

 999  continue
      return
      end
