      subroutine dflatwrite(filename,nunit,nlen,datmat,
     &           ioflag,ierr,cherr)
C-----------------------------------------------------------------------
C
C     This writes an unformatted IEEE 64bit Fortran binary file.
C
C     The return value (error code) returned in "ierr" can be
C     decoded as follows:
C
C     ierr > 0		normal termination, # of data written
C     ierr == -1	unable to open output file
C     ierr == -2	unable to write to output file
C
C     ARGUMENTS
C     -----------------------------
C     filename		The full pathname of the Fortran binary file
C     nunit		the Fortran unit # (for writing)
C     nlen		the # of elements
C     datmat		the matrix to write
C     ioflag		open/close handler ...
C     ierr 		the error code OR # of items written
C     cherr 		the error character string
C
C     ioflag == 1	open file, write, close file
C     ioflag == 2	open file, write, leave file open
C     ioflag == 3	file already open, write, leave file open
C     ioflag == 4	file already open, write, close file
C
C-----------------------------------------------------------------------

      implicit none

      character*256 filename
      integer	nunit, nlen
      real*8	datmat(nlen)
      integer	ioflag
      integer	ierr
      character*80 cherr

C --- ------------------------------------------------------------------
C --- Local variables
C --- ------------------------------------------------------------------

      integer slen

C --- ------------------------------------------------------------------

      slen = index(filename,"  ") - 2

      if (ioflag .LE. 2) then
         open(nunit,file=filename,status='unknown',form='unformatted',
     &     err=900)
         rewind(nunit)
      endif

      write(nunit,err=901)datmat

      if ((ioflag .EQ. 1).OR.(ioflag .EQ. 4)) close(nunit)

      ierr = nlen

      goto 999

 900  ierr = -1
      cherr = "ERROR(dflatwrite) opening "//filename(1:slen)
      goto 999

 901  ierr = -2
      cherr = "ERROR(dflatwrite) writing "//filename(1:slen)
      goto 999

 999  continue

      return
      end
