      subroutine getnfdims(nffn, varname, varndims, n, ierr, cherr) 
C-----------------------------------------------------------------------
C     nffn	netCDF filename
C     varname	netCDF variable
C     varndims	# of dimensions in variable
C     n 	total length of variable
C     ierr	error code       [ 0 is normal termination ]
C     cherr	character error string
C
C     *) set the variable ID
C     *) get all the variable attributes
C     *) find out the number of elements in the longitude variable
C       * this is the product of all the dim
C---------------------------------------------------------------------

      include 'netcdf.inc'

      character*128 nffn
      character*128 varname
      integer varndims
      integer n
      integer ierr
      character*80 cherr

C --- ------------------------------------------------------------------

      integer	ncid				! netCDF FILE     ID
      integer	varid				! netCDF VARIABLE ID
      integer	vardimids(NF_MAX_VAR_DIMS)	! variable shape
      integer     dimlen(NF_MAX_VAR_DIMS)	! variable shape
      integer	status				! error code
      character*128 dimname	! name of the current dimension
   
      integer	idim

C --- ------------------------------------------------------------------

      ierr = 0

      status = nf_open(nffn,NF_NOWRITE,ncid)
      if(status .NE. NF_NOERR) then
         ierr = status 
         cherr = nf_strerror(status)
         goto 999
      endif

      status = nf_inq_varid(ncid,varname,varid)
      if (status .NE. NF_NOERR) then
         ierr = status
         cherr = nf_strerror(status)
         goto 999
      endif

      status = nf_inq_varndims(ncid, varid, varndims)
      if (status .NE. NF_NOERR) then
         ierr = status
         cherr = nf_strerror(status)
         goto 999
      endif

      status = nf_inq_vardimid(ncid, varid, vardimids)
      if (status .NE. NF_NOERR) then
         ierr = status
         cherr = nf_strerror(status)
         goto 999
      endif 

      n = 1
      do idim = 1,varndims
         status = nf_inq_dim(ncid, vardimids(idim), dimname, 
     &                                dimlen(idim))
         if (status .NE. NF_NOERR) then
            ierr = status
            cherr = nf_strerror(status)
            goto 999
         endif 
         n = n*dimlen(idim)
      enddo
   
      status = nf_close(ncid)		! CLOSE netCDF FILE 
      if (status .NE. NF_NOERR) then
         ierr = status
         cherr = nf_strerror(status)
         goto 999
      endif 

 999  return
      end

      subroutine getnfvar(nffn,varname,varndims,dimlen,n,dp,ierr,cherr)
C-----------------------------------------------------------------------
C     nffn	character array		netCDF filename
C     varname	character array		netCDF variable
C     varndims	integer			# of dimension in variable
C     n 	integer 		total length of the variable
C     dimlen 	integer array		length of each dimension
C     dp	double	array
C     ierr	error code       [ 0 is normal termination ]
C     cherr	character error string
C --- ------------------------------------------------------------------
C     *) set the variable ID
C     *) extract the variable
C-----------------------------------------------------------------------

      include 'netcdf.inc'

      character*128 nffn
      character*128 varname
      integer varndims
      integer dimlen(NF_MAX_VAR_DIMS)
      integer n
      real*8  dp(n)
      integer ierr
      character*80 cherr

C --- ------------------------------------------------------------------

      integer	ncid 				! netCDF FILE     ID
      integer	varid 				! netCDF VARIABLE ID
      integer	status				! error code
      integer	vardimids(NF_MAX_VAR_DIMS)	! variable shape
      character*128 dimname	! name of the current dimension
   
C --- ------------------------------------------------------------------

      ierr = 0

      status = nf_open(nffn,NF_NOWRITE,ncid)
      if (status .NE. NF_NOERR) then
         ierr = status
         cherr = nf_strerror(status)
         goto 999
      endif  

      status = nf_inq_varid(ncid, varname, varid)
      if (status .NE. NF_NOERR) then
         ierr = status
         cherr = nf_strerror(status)
         goto 999
      endif  

      status = nf_inq_vardimid(ncid, varid, vardimids)
      if (status .NE. NF_NOERR) then
         ierr = status
         cherr = nf_strerror(status)
         goto 999
      endif 

      do idim = 1,varndims
         status = nf_inq_dim(ncid, vardimids(idim), dimname, 
     &                                dimlen(idim))
         if (status .NE. NF_NOERR) then
            ierr = status
            cherr = nf_strerror(status)
            goto 999
         endif 
      enddo
      
      status = nf_get_var_double(ncid, varid, dp)
      if (status .NE. NF_NOERR) then
         ierr = status
         cherr = nf_strerror(status)
         goto 999
      endif  
   
      status = nf_close(ncid)		! CLOSE netCDF FILE 
      if (status .NE. NF_NOERR) then
         ierr = status
         cherr = nf_strerror(status)
         goto 999
      endif  

 999  return
      end
