c======================================================================================
c Name         :   cff
c Date         :   2/18/05 (DLR)
c Copyright    : 2005-2006 Copyright University Corporation for Atmospheric
c                Research
c Description  :   Cache-friendly Fortran linear algebra routines
c Modifications:
c======================================================================================


c************************************************************************************
c************************************************************************************
c METHOD     : dmxm
c DESCRIPTION:
c ARGUMENTS  : 
c RETURNS    : 
c************************************************************************************
      subroutine dmxm(C, A, nai, naj, B, nbi, nbj, isz)
      integer nai, naj, nbi, nbj, isz
      real*8  C(nai,nbj), A(nai,naj), B(nbi,nbj)

      integer i, ii, j, jj, k, kk
      real*8  zero

c  Initialize C to 0:
      zero = 0.0
      call matset(C, nai, nbj, zero, isz)

c     write(*,*) 'dmxm: isz=', isz
c     write(*,*) 'dmxm: nai=', nai, ' aj=', naj, 
c    +           ' nbi=', nbi, ' nbj=', nbj
c     do i = 1, nai
c       do j = 1, naj
c           write(*,*) 'i=',i,' j=',j, ' A=', A(i,j)
c       enddo
c     enddo
c     do i = 1, nbi
c       do j = 1, nbj
c           write(*,*) 'i=',i,' j=',j, ' B=', B(i,j) 
c       enddo
c     enddo

c  Do matrix-matrix multiply:
      do ii = 1, nai, isz
        do jj = 1, nbj, isz
          do kk = 1, nbi, isz

            do i = ii, min(nai,ii+isz-1)
              do j = jj, min(nbj,jj+isz-1)
                do k = kk, min(nbi,kk+isz-1)
                  C(i,j) = C(i,j) + A(i,k)*B(k,j)
                enddo
              enddo
            enddo
          
          enddo
        enddo
      enddo

      return
c
c  end of subroutine dmxm
c
      end

c************************************************************************************
c************************************************************************************
c METHOD     : dmxv
c DESCRIPTION:
c ARGUMENTS  : 
c RETURNS    : 
c************************************************************************************
      subroutine dmxv(y, ny, A, x, nx, isz)
      integer ny, nx, isz
      real*8  y(ny), A(ny,nx), x(nx)

      integer i, ii, j, jj

      do ii = 1, ny, isz
        do i = ii, min(ny,ii+isz-1)
           y(i) = 0.0
        enddo
      enddo


c  Do matrix-vector multiply:
      do ii = 1, ny, isz
        do jj = 1, nx, isz

          do i = ii, min(ny,ii+isz-1)
            do j = jj, min(nx,jj+isz-1)
              y(i) = y(i) + A(i,j)*x(j)
            enddo
          enddo

        enddo
      enddo

      return
c
c  end of subroutine dmxv
c
      end

c************************************************************************************
c************************************************************************************
c METHOD     : dmxDm  
c DESCRIPTION: computes C = A * Diag(B). Dimensions of C assumed to be 
c              those of A
c ARGUMENTS  : 
c RETURNS    : 
c************************************************************************************
      subroutine dmxDm(C, A, nai, naj, b, nb, isz)
      integer nai, naj, nb, isz
      real*8  C(nai,naj), A(nai,naj), b(nb)

      integer i, ii, j, jj

c  Do matrix-Diag(matrix) multiply:
      do ii = 1, nai, isz 
        do jj = 1, naj, isz 

          do i = ii, min(nai,ii+isz-1)
            do j = jj, min(naj,jj+isz-1)
              C(i,j) = A(i,j)*b(j)
            enddo
          enddo

        enddo
      enddo   

      return  
c
c  end of subroutine dmxDm
c
      end     


c************************************************************************************
c************************************************************************************
c METHOD     : dDmxm  
c DESCRIPTION: computes C = Diag(A)*B. Dimensions of C assumed to be 
c              those of B
c ARGUMENTS  : 
c RETURNS    : 
c************************************************************************************
      subroutine dDmxm(C, a, na, B, nbi, nbj, isz)
      integer nbi, nbj, na, isz
      real*8  C(nbi,nbj), B(nbi,nbj), a(na)

      integer i, ii, j, jj

c  Do Diag(matrix)-matrix multiply:
      do ii = 1, nbi, isz 
        do jj = 1, nbj, isz 

          do i = ii, min(nbi,ii+isz-1)
            do j = jj, min(nbj,jj+isz-1)
              C(i,j) = a(i)*B(i,j)
            enddo
          enddo

        enddo
      enddo   

      return  
c
c  end of subroutine dDmxm
c
      end     


c************************************************************************************
c************************************************************************************
c METHOD     : dzaxpby
c DESCRIPTION:
c ARGUMENTS  : 
c RETURNS    : 
c************************************************************************************
      subroutine dzaxpby(z, x, a, y, b, nxy, isz)
      integer nxy, isz
      real*8  z(nxy), x(nxy), y(nxy), a, b

      integer i, ii
      real*8  prod

      isz = isz

c  Do vector sums:
      do ii = 1, nxy, isz
        do i = ii, min(nxy,ii+isz-1)
          prod = b*y(i) + 0.0
          z(i) = a*x(i) + prod
        enddo
      enddo

      return
c
c  end of subroutine dzaxpby
c
      end


c************************************************************************************
c************************************************************************************
c METHOD     : dxaxpby
c DESCRIPTION:
c ARGUMENTS  : 
c RETURNS    : 
c************************************************************************************
      subroutine dxaxpby(x, a, y, b, nxy, isz)
      integer nxy, isz
      real*8  x(nxy), y(nxy), a, b

      integer i, ii
      real*8  prod

c  Do vector sums:
      do ii = 1, nxy, isz
        do i = ii, min(nxy,ii+isz-1)
          prod = b*y(i) + 0.0
          x(i) = a*x(i) + prod
        enddo
      enddo

      return
c
c  end of subroutine dxaxpby
c
      end


c************************************************************************************
c************************************************************************************
c METHOD     : dzvxvpt
c DESCRIPTION:
c ARGUMENTS  : 
c RETURNS    : 
c************************************************************************************
      subroutine dzvxvpt(z, x, y, nxy, isz)
      integer nxy, isz
      real*8  z(nxy), x(nxy), y(nxy)

      integer i, ii

c  Do point product:
      do ii = 1, nxy, isz
        do i = ii, min(nxy,ii+isz-1)
          z(i) = x(i) * y(i) + 0.0
        enddo
      enddo

      return
c
c  end of subroutine dzvxvpt
c
      end


c************************************************************************************
c************************************************************************************
c METHOD     : dvvxvpt
c DESCRIPTION:
c ARGUMENTS  : 
c RETURNS    : 
c************************************************************************************
      subroutine dvvxvpt(x, y, nxy, isz)
      integer nxy, isz
      real*8  x(nxy), y(nxy)

      integer i, ii

c  Do point product:
      do ii = 1, nxy, isz
        do i = ii, min(nxy,ii+isz-1)
          x(i) = x(i) * y(i) + 0.0
        enddo
      enddo

      return
c
c  end of subroutine dvvxvpt
c
      end


c************************************************************************************
c************************************************************************************
c METHOD     : ddot
c DESCRIPTION:
c ARGUMENTS  : 
c RETURNS    : 
c************************************************************************************
      subroutine ddot(rdot, x, y, nxy, isz)
      integer nxy, isz
      real*8  rdot, x(nxy), y(nxy)

      integer i, ii

c  Do vector dot product:
      rdot = 0.0
      do ii = 1, nxy, isz
        do i = ii, min(nxy,ii+isz-1)
          rdot = rdot + x(i) * y(i) 
        enddo
      enddo

      return
c
c  end of subroutine ddot
c
      end


c************************************************************************************
c************************************************************************************
c METHOD     : dcopy
c DESCRIPTION: copies y into x
c ARGUMENTS  : 
c RETURNS    : 
c************************************************************************************
      subroutine dcopy(x, y, nxy, isz)
      integer nxy, isz
      real*8  x(nxy), y(nxy)

      integer i, ii

c  Do vector sums:
      do ii = 1, nxy, isz
        do i = ii, min(nxy,ii+isz-1)
          x(i) = y(i) 
        enddo
      enddo

      return
c
c  end of subroutine dcopy
c
      end

c************************************************************************************
c************************************************************************************
c METHOD     : matset
c DESCRIPTION: sets matrix to specified value
c ARGUMENTS  : 
c RETURNS    : 
c************************************************************************************
      subroutine matset(C, nci, ncj, val, isz)
      integer nci, ncj, isz
      real*8  C(nci,ncj), val

      integer i, ii

      do ii = 1, nci, isz
        do jj = 1, ncj, isz

          do i = ii, min(nci,ii+isz-1)
            do j = jj, min(ncj,jj+isz-1)
                C(i,j) = val
            enddo
          enddo

        enddo
      enddo

      return
c
c  end of subroutine matset
c
      end

