//************************************************************************************
// Module       : cff_wrappers.cpp
// Date         : 2/17/05 (DLR)
// Copyright    : 2005-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Wrappers for the Linear algebra Fortran functions
// Derived From : none.
// Modifications:
//************************************************************************************
#include "gtypes.h"
#include "cff_wrappers.hpp"
#include "cff_wrappers_extern.h"


void w_dmxm(GDOUBLE C[], GDOUBLE A[], GINT nai, GINT naj, GDOUBLE B[], GINT nbi, GINT nbj, GINT isz)
{
#if defined(_LINUX) 
  dmxm_(C, A, &nai, &naj, B, &nbi, &nbj, &isz);
#elif defined(_AIX)
  dmxm (C, A, &nai, &naj, B, &nbi, &nbj, &isz);
#else
  DMXM_(C, A, &nai, &naj, B, &nbi, &nbj, &isz);
#endif
} // end of function wrappers w_dmxm


void w_dmxv   (GDOUBLE y[], GINT ny, GDOUBLE A[], GDOUBLE x[], GINT nx, GINT isz)
{
#if defined(_LINUX)
  dmxv_  (y, &ny, A, x, &nx, &isz);
#elif defined(_AIX)
  dmxv   (y, &ny, A, x, &nx, &isz);

#else
  DMXV_  (y, &ny, A, x, &nx, &isz);
#endif
} // end of function wrappers w_dmxm

void w_dmxDm  (GDOUBLE C[], GDOUBLE A[],GINT nai, GINT naj, GDOUBLE b[], GINT nb, GINT isz)
{
#if defined(_LINUX) 
   dmxdm_ (C, A, &nai, &naj, b, &nb, &isz);
#elif defined(_AIX)
   dmxdm  (C, A, &nai, &naj, b, &nb, &isz);

#else
   MXDM_ (C, A, &nai, &naj, b, &nb, &isz);
#endif

}

void w_dDmxm  (GDOUBLE C[], GDOUBLE a[], GINT na, GDOUBLE B[], GINT nbi, GINT nbj, GINT isz)
{
#if defined(_LINUX)
  ddmxm_ (C, a, &na, B, &nbi, &nbj, &isz);
#elif defined(_AIX)
  ddmxm  (C, a, &na, B, &nbi, &nbj, &isz);
#else
  DDMXM_ (C, a, &na, B, &nbi, &nbj, &isz);
#endif
} 

void w_dzaxpby(GDOUBLE z[], GDOUBLE x[], GDOUBLE a, GDOUBLE y[], GDOUBLE b, GINT nxy, GINT isz)
{
#if defined(_LINUX) 
  dzaxpby_(z, x, &a, y, &b, &nxy, &isz);
#elif defined(_AIX)
  dzaxpby (z, x, &a, y, &b, &nxy, &isz);
#else
  DZAXPBY_(z, x, &a, y, &b, &nxy, &isz);
#endif
} 

void w_dxaxpby(GDOUBLE x[], GDOUBLE a, GDOUBLE y[], GDOUBLE b, GINT nxy, GINT isz)
{
#if defined(_LINUX) 
  dxaxpby_(x, &a, y, &b, &nxy, &isz);
#elif defined(_AIX)
  dxaxpby (x, &a, y, &b, &nxy, &isz);
#else
  DXAXPBY)(x, &a, y, &b, &nxy, &isz);
#endif
} 

void w_dzvxvpt(GDOUBLE z[], GDOUBLE x[], GDOUBLE y[], GINT nxy, GINT isz)
{
#if defined(_LINUX) 
  dzvxvpt_(z, x, y, &nxy, &isz);
#elif defined(_AIX)
  dzvxvpt (z, x, y, &nxy, &isz);
#else
  DZVXVPT_(z, x, y, &nxy, &isz);
#endif
} 

void w_dvvxvpt(GDOUBLE x[], GDOUBLE y[], GINT nxy, GINT isz)
{
#if defined(_LINUX)
  dvvxvpt_(x, y, &nxy, &isz);
#elif defined(_AIX)
  dvvxvpt (x, y, &nxy, &isz);
#else
  DVVXVPT_(x, y, &nxy, &isz);
#endif
} 


void w_ddot   (GDOUBLE *dot, GDOUBLE x[], GDOUBLE y[], GINT nxy, GINT isz)
{
#if defined(_LINUX) 
  ddot_ (dot, x, y, &nxy, &isz);
#elif defined(_AIX)
  ddot  (dot, x, y, &nxy, &isz);
#else
  DDOT_ (dot, x, y, &nxy, &isz);
#endif
} 

void w_dcopy(GDOUBLE x[], GDOUBLE y[], GINT nxy, GINT isz)
{
#if defined(_LINUX) 
  dcopy_(x, y, &nxy, &isz);
#elif defined(_AIX)
  dcopy (x, y, &nxy, &isz);
#else
  DCOPY_(x, y, &nxy, &isz);
#endif
} 

