//************************************************************************************//
// Module       : gtmatrix.hpp
// Date         : 7/9/01 (DLR)
// Copyright    : 2001-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                a template matrix object, whose data is composed of
//                a regular array of contiguous data, ordered like a Fortran
//                matrix in row-major order (row data changing fastest over column data).
// Derived From : LinOp.
// Modifications:
//************************************************************************************//
#if !defined(GTMATRIX_HPP)
#define GTMATRIX_HPP
#include <stdlib.h>
#include <memory.h>
#include <iomanip.h>
#include <iostream.h>
#include "gtypes.h"
#include "gtvector.hpp"
#include "linop.hpp"

#if !defined(SEMatrix)
#  define GMatrix GTMatrix<GDOUBLE>
#endif

#if !defined(SEBasisMatrix)
#  define GBasisMatrix GTMatrix<GQUAD>
#endif

//class T;
//template<class T> class GTVector;
template<class T> class GTMatrix: public LinOp
{
public:
                          GTMatrix();
                          GTMatrix(const GINT , const GINT );
                          GTMatrix(T *array, GINT  n1, GINT  n2);
                          GTMatrix(const GTMatrix<T> &);

                         ~GTMatrix();

         GTMatrix<T>      operator=(const GTMatrix<T> &);
         void             operator=(T );
         GTMatrix<T>      operator*(GTMatrix<T> )       ;
         GTVector<T>      operator*(GTVector<T> )       ; // right multiplication: Matrix * Array
         GTMatrix<T>      operator*(T)                  ; // right multiplication: Matrix * const

         GTMatrix<T>      operator+(GTMatrix<T>  ) ; // addition
         GTMatrix<T>      operator-(GTMatrix<T>  ) ; // addition
         GBOOL            Transpose(GTMatrix<T> &);
         GTMatrix<T>      Transpose();
         GBOOL            Inverse(GTMatrix<T> &);
         GTMatrix<T>      Inverse();
         GBOOL            isSymmetric();

inline          T         &operator()(const GINT  i, const GINT  j ){
#if defined(GARRAY_BOUNDS)
                          if ( i >= n1 || i < 0 || j >= n2 || j < 0  ) {
                            cout << "GTMatrix<T>::&(): access error: i=" << i << "; j=" << j << endl;
                            exit(1);
                            }
#endif
                          return data[i+j*n1];} 
         GINT              tsize(GINT  idir);  // _total_ size = n_idir 
         GINT              dim(GINT  idir) ;

         T                 *Data() ;
         GTVector<T>       *VData() ;
         GBOOL             Resize(GINT  Nx, GINT  Ny);
         void              Zero();
  
         friend ostream&   operator<<(ostream &, GTMatrix<GDOUBLE> & );
#if defined(GBUFF_DEF_GQUAD)
         friend ostream&   operator<<(ostream &, GTMatrix<GQUAD> & );
#endif

private:

// Private methods:
void              DeleteDynamic();
GBOOL             ludcmp (T **&a, GINT  n, GINT  *&indx, T *d);
GBOOL             wludcmp(T **&a, GINT  n, GINT  *&indx, T *d);
GBOOL             lubksb (T **&a, GINT  n, GINT  *&indx, T b[]);
GINT              isamax(GINT  n, GDOUBLE *sx, GINT  incx);


// Private data:
GINT              n1;
GINT              n2;
G_DATATYPE        dtype;
GC_DATATYPE       cdtype;

GTVector<T>       data;
T                 fNULL;
#if defined(DO_BLAS_TIMING)
public:
        GDOUBLE   GetTime(GINT  i){if      ( i==0 ) return time_result;
                                   else if ( i==1 ) return time_result1;
                                   else if ( i==2 ) return time_result2; }
private:
        GDOUBLE   time_result;
        GDOUBLE   time_result1;
        GDOUBLE   time_result2;
#endif




};
# if defined(_LINUX) || defined(_AIX)
template class GTMatrix<GDOUBLE>;
ostream &operator <<(ostream&, GTMatrix<GDOUBLE>&);
#if  defined(GBUFF_DEF_GQUAD)
template class GTMatrix<GQUAD>;
ostream &operator <<(ostream&, GTMatrix<GQUAD>&);
#    endif
#  endif
#endif
