//************************************************************************************//
// Module       : gtvector.hpp
// Date         : 7/9/01 (DLR)
// Copyright    : 2001-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                a template vector object
// Derived From : none.
// Modifications:
//************************************************************************************//
#if !defined(GTVECTOR_HPP)
#define GTVECTOR_HPP

#include "gtypes.h"
#include <stdlib.h>
#include <iostream.h>
#include <memory.h>
#include <math.h>
#include "gindex.hpp"
#include "gtbuffer.hpp"

#if !defined(GVector)
#  define GVector GTVector<GDOUBLE>
#endif

#if !defined(QVector)
#  define QVector GTVector<GQUAD>
#endif

#if !defined(GBasisVector)
#  define GBasisVector GTVector<GQUAD>
#endif

#if defined(VEC_LEVEL0_TIMING)||defined(VEC_LEVEL1_TIMING)||defined(VEC_LEVEL2_TIMING)||defined(VEC_LEVEL3_TIMING)
#define DO_VEC_TIMING
#include "timer.h"
#endif

//template<GINT> class GBuffer;


template<class T> class GTVector
{
public:
                           GTVector();
                           GTVector(GINT );
                           GTVector(GIndex );
                           GTVector(GDOUBLE *, GINT  n );
                           GTVector(const GTVector &);
virtual                   ~GTVector();

         GTVector<T>       operator=(GTVector<T> );
         void              operator=(T);
         void              operator+=(GTVector<T> );
         void              operator-=(GTVector<T> );
         void              operator*=(T a);
         GTVector<T>       operator*(T )       ; // right multiplication: Array * const
//       GTVector<T>       operator*(SETMatrix<T> &)     ; // right multiplication by matrix
         T                 operator*(GTVector<T>  )      ; // vector inner product
         GTVector<T>       operator+(GTVector<T>  )      ; // array addition 
         GTVector<T>       operator-(GTVector<T>  )      ; // array subtraction
         void              veconst_prod(T a, GTVector<T> &ret);

inline   T                &operator()(const GINT  i){ 
                           if ( i >= index.szglobal() || i < 0 ) {
                             cout << "GTVector<T>:&(): i=" << i << endl;
                             cout << "template<class T> GTVector<T>::&(): access error"<< endl;
                             exit(1);}
                           if ( i<index.beg() || i>index.end() ) return (fNULL=0.0);
                           return *(data+i-index.beg()+index.base()); }

inline   T                &operator[](const GINT  i){ 
                           if ( i >= index.szglobal() || i < 0 ) {
                             cout << "GTVector<T>:&[]: i=" << i << endl;
                             cout << "template<class T> GTVector<T>::&[]: access error"<< endl;
                             exit(1);}
                           if ( i<index.beg() || i>index.end() ) return (fNULL=0.0);
                           return *(data+i-index.beg()+index.base()); }

inline   T                 operator[](const GINT  i) const { 
#if defined(GARRAY_BOUNDS)
                           if ( i >= index.szglobal() || i < 0 ) {
                             cout << "GTVector<T>:[]: i=" << i << endl;
                             cout << "template<class T> GTVector<T>::[]: access error"<< endl;
                             exit(1); }
                           if ( i<index.beg() || i>index.end() ) return 0.0;
#endif
                           T tret = *(data+i-index.beg()+index.base());
                           return tret; }

inline   T                 operator()(const GINT  i) const { 
#if defined(GARRAY_BOUNDS)

                           if ( i >= index.szglobal() || i < 0 ) {
                             cout << "GTVector<T>:(): i=" << i << endl;
                             cout << "template<class T> GTVector<T>::(): access error"<< endl;
                             exit(1); }
                           if ( i<index.beg() || i>index.end() ) return 0.0;
#endif
                           T tret = *(data+i-index.beg()+index.base());
                           return tret; }

inline   void              operator()(GINT  ib, GINT  ie, GINT  is, GINT  ibase) { index(ib, ie, is, ibase); }

         friend ostream&   operator<<(ostream &, const GTVector<GDOUBLE> &);
#if defined(GBUFF_DEF_GQUAD)
         friend ostream&   operator<<(ostream &, const GTVector<GQUAD> &);
#endif
    
                   
      // GIndex           *GetIndex() const;
         GIndex            GetIndex() const;
         GBOOL             isDistributed();
         GINT              tsize();  // _total_ size = n + npad_
         GINT              dim() const;    // working size: n
         T                 Min();
         T                 MinA();
         T                 Max();
         T                 MaxA();
         T                *Data() const;
         T                 EuclidNorm(GDOUBLE *multiplicity=NULL);
         void              GetSection(GINT  *indices, GINT  nindices, GTVector<T> &vret);
         void              Zero(GBuffer<GINT>  *indices=NULL);
         void              Set(T val, GBuffer<GINT>  *indices, GBuffer<GINT>  *i_exclude=NULL);
         void              Set(T val, GINT  *indices, GINT  ni);
         GBOOL             Resize(GINT  newdim);
         GBOOL             Resize(GINT  newdim, GINT  beg_, GINT  end_);
#if defined(DO_VEC_TIMING)
        GDOUBLE              GetTime(){return time_result;}
#endif


private:

// Private methods:
        void               DeleteDynamic();


// Private data:
        GINT               n;
        GBOOL              bDistributed;
        G_DATATYPE         dtype;
        GC_DATATYPE        cdtype;
        GIndex             index;
        T                  *data;
        T                  fNULL;
#if defined(DO_VEC_TIMING)
        GDOUBLE              time_result;
#endif



};

#  if defined(_LINUX) || defined(_AIX)
template class GTVector<GDOUBLE> ;
ostream &operator <<(ostream&, const GTVector<GDOUBLE>&);
#    if defined(GBUFF_DEF_GQUAD)
template class GTVector<GQUAD> ;
ostream &operator <<(ostream&, const GTVector<GQUAD>&);
#    endif
#  endif
#endif




