//************************************************************************************//
// Module       : setvmatrix.hpp
// Date         : 7/9/01 (DLR)
// Copyright    : 2001-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                a template matrix object, whose data is composed of
//                variable length vectors.
// Derived From : LinOp.
// Modifications:
//************************************************************************************//
#if !defined(SETVMATRIX_HPP)
#define SETVMATRIX_HPP
#include <iostream.h>
#include <stdlib.h>
#include <memory.h>
#include <iomanip.h>
#include <iostream.h>
#include "gtypes.h"
#include "gtvector.hpp"
#include "linop.hpp"

#if !defined(SEMatrix)V
#  define SEMatrix SETVMatrix<GDOUBLE>
#endif

#if !defined(SEBasisMatrix)
#  define SEVBasisMatrix SETVMatrix<GQUAD>
#endif

//class T;
//template<class T> class SETVector;
template<class T> class SETVMatrix: public LinOp
{
public:
                          SETVMatrix();
                          SETVMatrix(const ISUB, const ISUB);
                          SETVMatrix(GIndex &s1,GIndex &s2);
                          SETVMatrix(GIndex &s1,GIndex &s2, ISUB **);
                          SETVMatrix(GIndex &s1,GIndex &s2, ISUB nUpper, ISUB nLower);
                          SETVMatrix(T *array, ISUB n1, ISUB n2);
                          SETVMatrix(const SETVMatrix<T> &);

                         ~SETVMatrix();

virtual  SETVMatrix<T>     operator=(const SETVMatrix<T> &);
virtual  void             operator=(T );
virtual  SETVMatrix<T>     operator*(SETVMatrix<T> )       ;
virtual  SETVector<T>     operator*(SETVector<T> )       ; // right multiplication: Matrix * Array
virtual  SETVMatrix<T>     operator*(T)                   ; // right multiplication: Matrix * const

virtual  SETVMatrix<T>     operator+(SETVMatrix<T>  ) ; // addition
virtual  SETVMatrix<T>     operator-(SETVMatrix<T>  ) ; // addition
         friend ostream&  operator<<(ostream &, SETVMatrix<GDOUBLE> );
         friend ostream&  operator<<(ostream &, SETVMatrix<GQUAD> );
virtual  GBOOL            Transpose(SETVMatrix<T> &);
virtual  SETVMatrix<T>     Transpose();
virtual  GBOOL            Inverse(SETVMatrix<T> &);
virtual  SETVMatrix<T>     Inverse();
virtual  GBOOL            isSymmetric();

inline virtual  T         &operator()(const ISUB i, const ISUB j ){
                          if ( i-beg(1) >= dim(1) || i < 0 || j-beg(2) >= dim(2) || j < 0  ) {
                            cout << "SETVMatrix<T>::&(): access error"<< endl;
                            exit(1);
                            }
                          SETVector<T> *v;
                          T            *p;
                          v = data[i-beg(1)];
                          if ( i < beg(1) || i > end(1) ) return ( fNULL=0.0 );
                          if ( j < v->GetIndex().beg() || j > v->GetIndex().end() ) return ( fNULL=0.0 );
                          return (*v)(j);}  //*(v->Data() + j - v->GetIndex().beg());}



inline  virtual  T        operator()(const ISUB i , const ISUB j ) const {
                          if ( i-beg(1) >= dim(1) || i < 0 || j-beg(2) >= dim(2) || j < 0  ) {
                            cout << "SETVMatrix<T>::&(): access error"<< endl;
                            exit(1);
                            }
                          SETVector<T> *v;
                          T            *p;
                          v = data[i-beg(1)];
                          if ( i < beg(1) || i > end(1) ) return (0.0 );
                          if ( j < v->GetIndex().beg() || j > v->GetIndex().end() ) return (0.0 );
                          return (*v)(j);}   //*(v->Data() + j - v->GetIndex().beg());}
                   
virtual  GIndex          GetIndex(ISUB idir) const ;
virtual  ProcMapping       GetProcMapping();
virtual  GBOOL             isDistributed();
virtual  ISUB             tsize(ISUB idir);  // _total_ size = n_idir + n_idir_pad_
virtual  ISUB             dim(ISUB idir) const;
virtual  ISUB             beg(ISUB idir) const;
virtual  ISUB             end(ISUB idir) const;

virtual  SETVector<T>    **Data() const;
virtual  GBOOL             Resize(ISUB Nx, ISUB Ny);
virtual  void              Zero();
  

private:

// Private methods:
void              DeleteDynamic();
GBOOL             ludcmp (T **&a, ISUB n, ISUB *&indx, T *d);
GBOOL             wludcmp(T **&a, ISUB n, ISUB *&indx, T *d);
GBOOL             lubksb (T **&a, ISUB n, ISUB *&indx, T b[]);
ISUB              isamax(ISUB n, GDOUBLE *sx, ISUB incx);


// Private data:
ISUB             n1;
ISUB             n2;
GBOOL             bDistributed;
ProcMapping       iProcMap;
G_DATATYPE        dtype;

GIndex          gindex1;
GIndex          gindex2;
ISUB            *jMap[2];  // bounding j-indices for compressed storage for each row, i
SETVector<T>     **data;
T                 fNULL;
#if defined(DO_BLAS_TIMING)
public:
        GDOUBLE            GetTime(ISUB i){if      ( i==0 ) return time_result;
                                          else if ( i==1 ) return time_result1;
                                          else if ( i==2 ) return time_result2; }
private:
        GDOUBLE            time_result;
        GDOUBLE            time_result1;
        GDOUBLE            time_result2;
#endif




};
# if defined(_LINUX)
template class SETVMatrix<GDOUBLE>;
ostream &operator<<(ostream &, SETVMatrix<GDOUBLE> );
template class SETVMatrix<GQUAD>;
ostream &operator<<(ostream &, SETVMatrix<GQUAD> );
#  endif
#endif
