//************************************************************************************
// Module       : gcomm.hpp
// Date         : 5/14/02 (DLR)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Namespace encapsulating general communications
//                utilities.
// Derived From : none.
// Modifications:
//************************************************************************************
#if !defined(GCOMM_HPP)
#define GCOMM_HPP

#include "gtypes.h"
#include "gtbuffer.hpp"
#if defined(MPI_GENERIC_DEFAULT)
#  include "mpi.h"
#endif


#if defined(MPI_GENERIC_DEFAULT)
// There must be a 1-1 correspondence between the elems of this
// array, G2MPI_OPTYPE,  and enum G_OP:
extern MPI_Op        G2MPI_OPTYPE[]  ;
//extern MPI_Request *mpi_recv_req  ;
#endif

#if !defined(GPARTITIONMAP_DEF)
#define GPARTITIONMAP_DEF
#define NPARTMAPST_MEM (5)
struct stGPartitionMap {
GKEY    elem_key;
GKEY    parent_key;
GSHORT  proc_to;
GSHORT  bcoarsened;
GFLOAT  center[GDIM];
friend ostream&  operator<<(ostream&os, stGPartitionMap &pm) {
os   << "elem_key  =" << pm.elem_key   << endl
     << "parent_key=" << pm.parent_key << endl
     << "proc_to   =" << pm.proc_to    << endl
     << "bcoarsened=" << pm.bcoarsened << endl;
return os;
}
};
#endif

namespace GComm
{

  void     InitComm   (int *argc, char **argv[]);
  void     TermComm   ();
  GSHORT   WorldRank       ();
  GSHORT   WorldSize       ();
  GBOOL    ASendRecv  (void      **RecvBuff, GINT  nRecvBuff, GINT  *irecv, GINT  *maxRecvLen, GC_DATATYPE rtype, GSHORT  *source, GBOOL bUseSource, 
                      void      **SendBuff, GINT  nSendBuff, GINT  *isend, GINT  *maxSendLen, GC_DATATYPE stype, GSHORT  *dest   );
  GBOOL    ASendRecvDB(GDWBuffer  **RecvBuff, GINT  nRecvBuff, GINT  *irecv, GINT  maxRecvLen, GSHORT  *source, GBOOL bUseSource,
                       GDWBuffer  **SendBuff, GINT  nSendBuff, GINT  *isend, GINT  maxSendLen, GSHORT  *dest   );
  GBOOL    ASendRecvNB(GNIDBuffer  **RecvBuff, GINT  nRecvBuff, GINT  *irecv, GINT  maxRecvLen, GSHORT  *source, GBOOL bUseSource,
                       GNIDBuffer  **SendBuff, GINT  nSendBuff, GINT  *isend, GINT  maxSendLen, GSHORT  *dest   );
  GSHORT   Allreduce  (void *, void *, const GINT  count, GC_DATATYPE data_type, G_OP op);
  GSHORT   Allreduce  (void *, void *, const GINT  count, GC_DATATYPE data_type, G_OP op, void *);
  GSHORT   Allreduce  (void *, void *, const GINT  count, GC_DATATYPE data_type, GBOOL b, G_OP op);
  GSHORT   Allgather  (void *operand, GINT  sendcount, GC_DATATYPE stype, void *result, GINT  recvcount, GC_DATATYPE gtype);
  GSHORT   Allgather  (void *operand, GINT  sendcount, GC_DATATYPE stype, void *result, GINT  recvcount, GC_DATATYPE gtype, void *);

  void     ARecv      (void **rbuff, GINT  buffcount, GINT  *bufflen, GINT  *buffindex, GC_DATATYPE rtype, GSHORT  *source, CHandle &);
  GBOOL    BSend      (void **rbuff, GINT  buffcount, GINT  *bufflen, GINT  *buffindex, GC_DATATYPE stype, GSHORT  *dest  );
  GBOOL    AWaitOnRecv(CHandle &handle);
  GBOOL    DataTypeFromStruct(AGINT  blk_ptr[], GC_DATATYPE blk_types[], GINT  n_type[],
                              const GINT  num_typ, GC_DATATYPE *return_type);
  void     DataTypeFree(GC_DATATYPE *type);
  void     Address(void *location, AGINT  *address);
  void     Synch();
  void     Synch(void *);	
  
  // private data:

}

#endif

