//************************************************************************************//
// Module       : gfieldgroup.cpp
// Date         : 6/25/05 (DLR)
// Copyright    : 2005-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the access methods and data associated with
//                defining a field group class. This associates an element with a 
//                list of fields that are associated with the elements.
// Derived From : none.
// Modifications:
//************************************************************************************//
#include "gfieldgroup.hpp"

//************************************************************************************
//************************************************************************************
// Constructor Method (1)
GFieldGroup::GFieldGroup()
:
nfields          (0),
basis_type       (GBASIS_GLL),
pelems           (NULL),
pfields          (NULL)
{
  memset(name,'\0',CMD_STR_MAX);
} // end of constructor method (1)


//************************************************************************************
//************************************************************************************
// Destructor
GFieldGroup::~GFieldGroup()
{
  if ( pfields ) delete [] pfields;
}


//************************************************************************************
//************************************************************************************
// METHOD     : output stream operator
// DESCRIPTION: 
// ARGUMENTS  : 
//                         
// RETURNS    : none
//************************************************************************************
ostream &operator<<(ostream &str, GFieldGroup &a)
{ 
  GINT i;

  cout << "pelems =" << a.pelems << endl;
  cout << "pfields: " ;
  for ( i=0; i<a.nfields-1; i++ ) cout << a.pfields[i] << ", " ;
  if ( a.nfields ) cout << a.pfields[a.nfields-1] << endl;
  
  return str;

}  // end of method operator<<
