//************************************************************************************//
// Module       : gfieldgroup.hpp
// Date         : 6/25/05 (DLR)
// Copyright    : 2005-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the access methods and data associated with
//                defining a field group class. This associates an element with a 
//                list of fields that are associated with the elements.
// Derived From : none.
// Modifications:
//************************************************************************************//
#if !defined(GFIELDGROUP_HPP)
#define GFIELDGROUP_HPP

#include "gtypes.h"
#include <iostream.h>
#include <stdlib.h>
#include "gelemlist.hpp"
#include "gfieldlist.hpp"


class GFieldGroup
{
public:
                           GFieldGroup();
                          ~GFieldGroup(); 
         friend           ostream &operator<<(ostream &str, GFieldGroup &a);


         GINT              nfields;
         char              name[CMD_STR_MAX];
         GBASIS_TYPE       basis_type;
         GElemList        *pelems; 
         GFieldList      **pfields;

};

#endif

