//************************************************************************************//
// Module       : gmortar1d.cpp
// Date         : 7/10/03 (DLR)
// Copyright    : 2003-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                a 'mortar' object, which provides all the information
//                required to maintain connectivity between spectral
//                elements. Mortar in this class represents the true
//                global degrees of freedom.
// Derived From : none.
// Modifications:
//************************************************************************************//
#if !defined(G_MORTAR1D_HPP)
#define G_MORTAR1D_HPP

#include "gtypes.h"
#include "gnbasis.hpp"
#include "gtvector.hpp"
#include "gtmatrix.hpp"
#include "gtbuffer.hpp"
#include "elem2d.hpp"
#include "point.hpp"

class Elem2D;
class GMortar1D
{
public:
         GMatrix           *IH2M_;    // interp matrix: host -->mortar
         GMatrix           *IM2H_;    // interp matrix: mortar->host

                           GMortar1D(GNBasis *b=NULL);
                          ~GMortar1D();

         void              SetBasis(GNBasis *b);                                // Set basis
         void              SetBdyPoints(Point3D &p_orig, Point3D &p_end);       // Set bdy points defining mortar geom.
         void              SetNodeIDs(GINT  n, GINT  *ids);                     // Set mortar's nodal ids (overrides any defaults)
         void              SetHostGrid(GVector **xhost, GINT  nc, 
                                       GINT  *indices, GINT  ni);               // Set host's grid corresp to mortar nodes
         GNBasis           *GetBasis();                                         // Get basis in direction idir
         Point3D           *GetBdyPoints(GINT  &nbdy);                          // Get bdy points and number
         GVector           *GetNodeIDs();                                       // Get global node ids
         GVector           *GetSpGrid(GINT  idir);                              // Get spatial mortar grid points for direction idir
         GVector           *GetArcPoints();                                     // Get spatial mortar points along mortar
         GVector           *GetMortarField();                                   // Get mortar internal field variable
         void              Mortar2Host(GVector *uout, GINT  *indices, GINT  ni,
                                       GINT  istart, GBOOL bAdd=FALSE);
         void              Mortar2Host(GDOUBLE   *uout, GINT  nu, GINT  *indices, GINT  ni, 
                                       GINT  istart, GBOOL bAdd=FALSE);         // Get mortar field interpolated to host gri
         void              Host2Mortar(Elem2D *ehost, GVector *uhost, GINT  &istart, GINT  &iend); 
                                                                                // Set mortar field from host element/field
         void              Host2Mortar(GVector *uin, GINT  *indices, GINT  ni, GINT  istart);
         void              Host2Mortar(GDOUBLE   *uin, GINT  nu, GINT  *indices, GINT  ni, GINT  istart);
                                                                                // Set mortar field from host element/field
         GBOOL            &isConforming();                                      // Get flag treating mortar as conforming wrt host       

private:
         // Methods:
         void              DeleteDynamic();
         void              Resize(GINT  newN);

         // Member data:
         GINT              nBdy_;
         GINT              NN_;
         GINT              istart_;
         GINT              *iorder_;
         GBOOL             bConforming_;
         GBOOL             bHostGrid_;
         GQUAD             len_;
         GQUAD             ilen_;
         GQUAD             smin_;
         GQUAD             smax_;
         GDOUBLE             *xBdy_[GDIM];           
         Point3D           *pBdy_;
         GIBuffer          *node_ids_;
         GNBasis           *mtr_basis_;
         GNBasis           *hst_basis_;
         GVector           *u_mtr_;
         GVector           *u_mtr1_;
         GVector           *xi_mtr_;
         GVector           *s_mtr_;
         GVector           *x_mtr_[GDIM];
         GVector           *u_hst_;
         GVector           *xi_hst_;
         GVector           *x_hst_[GDIM];
};

#endif
