//************************************************************************************//
// Module       : gneighbor.cpp
// Date         : 7/10/03 (DLR)
// Copyright    : 2003-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the access methods and data associated with
//                defining a GASpAR element neighbor
// Derived From : none.
// Modifications:
//************************************************************************************//
#include "gneighbor.hpp"
#include <string>

//************************************************************************************
//************************************************************************************
// Constructor Method (1)
GNeighbor::GNeighbor()
:
proc_id_         (0),
iancillary_      (0),
comp_id_         (0),
elem_key_        (0),
elem_root_key_   (0),
elem_id_         (0)
{
} // end of constructor method (1)


//************************************************************************************
//************************************************************************************
// Destructor
GNeighbor::~GNeighbor()
{
}


//************************************************************************************
//************************************************************************************
// METHOD     :  << operator method (1)
// DESCRIPTION: output stream operator
// ARGUMENTS  :
//
// RETURNS    :
//************************************************************************************
ostream &operator<<(ostream &str, GNeighbor &a)
{
  GINT  comptype, iedge, ipoint;

  comptype = (GINT )COMPTYP(&a.comp_id_);
  iedge    = (GINT )COMPNUM(&a.comp_id_);
  ipoint   = (GINT )COMPANC(&a.comp_id_);
  str << "Elem_Key: " << a.elem_key_ << " Elem_Root_Key: " << a.elem_root_key_ 
      << "; Elem_id: " << a.elem_id_ 
      << "; Comp_id: " << a.comp_id_ << "; Comp_type: " << comptype 
      << "; Edge_num: " << iedge << "; Point_id: " << ipoint << "; Ancillary_data: " 
      << a.iancillary_<< "; Proc: " << a.proc_id_;
  return str;
} // end of operator <<

