//************************************************************************************//
// Module       : gpartmapper.cpp
// Date         : 6/9/05 (DLR)
// Copyright    : 2005-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the access methods and data associated with
//                generating an element/proc mapping for grid partitioning.
//                This class is meant to be an interface base clase  to all 
//                other map generator classes.
// Derived From : none.
// Modifications:
//************************************************************************************//
#include "gpartmapper.hpp"

//************************************************************************************
//************************************************************************************
// Constructor Method (1)
GPartMapper::GPartMapper(GElemList *gelems)
:
nprocs_           (GComm::WorldSize()),
this_rank_        (GComm::WorldRank()),
bDoCurve_         (FALSE),
gnelems_          (0),
kcoarsen_         (NULL),
gelems_           (gelems),
curve_            (NULL)
{
  char              *serr = "GPartMapper::GPartMapper(1) : ";
  AGINT             *blk_ptr;
  GINT              *n_types, j;
  GC_DATATYPE       *sz_types;
  stGPartitionMap   pmstruct;

  if ( gelems_ == NULL ) {
    cout << serr << "NULL element list" << endl;
    exit(1);
  }

  // Register partion map datatype for communication purposes.
  // Refer to this datatype as pm_type_:
  blk_ptr  = new AGINT       [NPARTMAPST_MEM];
  n_types  = new GINT        [NPARTMAPST_MEM];
  sz_types = new GC_DATATYPE [NPARTMAPST_MEM];
  for ( j=0; j<4; j++ ) n_types[j] = 1;
  n_types[4] = GDIM;

  sz_types[0] = GC_GKEY;
  sz_types[1] = GC_GKEY;
  sz_types[2] = GC_GSHORT;
  sz_types[3] = GC_GSHORT;
  sz_types[4] = GC_GFLOAT;
  GComm::Address(&(pmstruct.elem_key)      , &blk_ptr[0]);
  GComm::Address(&(pmstruct.parent_key)    , &blk_ptr[1]);
  GComm::Address(&(pmstruct.proc_to)       , &blk_ptr[2]);
  GComm::Address(&(pmstruct.bcoarsened)    , &blk_ptr[3]);
  for ( j=0; j<GDIM; j++ ) 
    GComm::Address(&(pmstruct.center[0])   , &blk_ptr[4]);

  if ( !GComm::DataTypeFromStruct(blk_ptr, sz_types, n_types, NPARTMAPST_MEM, &pm_type_) ) {
    cout << serr << "Comm partition map datatype registration failed" << endl;
    exit(1);
  }
  delete [] blk_ptr; delete [] n_types; delete [] sz_types;
  
} // end of constructor method (1)


//************************************************************************************
//************************************************************************************
// Destructor
GPartMapper::~GPartMapper()
{
  if ( curve_ != NULL ) delete [] curve_;
   GComm::DataTypeFree(&pm_type_);
}

//************************************************************************************
//************************************************************************************
// METHOD     : SetCoarsenables
// DESCRIPTION: 
// ARGUMENTS  :
// RETURNS    : none.
//************************************************************************************

void GPartMapper::SetCoarsenables(GKEYBuffer *kbuff)
{
  kcoarsen_ = kbuff;
} // end of SetCoarsenables


//************************************************************************************
//************************************************************************************
// METHOD     : SetDoCurve
// DESCRIPTION: sets flag to compute space-filling curve or not
// ARGUMENTS  :
// RETURNS    : none.
//************************************************************************************

void GPartMapper::SetDoCurve(GBOOL bset)
{
  bDoCurve_ = bset;
} // end of SetDoCurve


//************************************************************************************
//************************************************************************************
// METHOD     : GetCurve
// DESCRIPTION: gets points representing space filling curve.
// ARGUMENTS  : npoints: number points in represented in returned array. Each 3 array
//                       elements represents 1 point.
// RETURNS    : GDOUBLE array of doubles
//************************************************************************************

GDOUBLE *GPartMapper::GetCurve(GINT &npoints)
{
  npoints = gnelems_;
  return curve_;
} // end of GetCurve

