//************************************************************************************//
// Module       : gpartmapper.hpp
// Date         : 6/9/05 (DLR)
// Copyright    : 2005-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the access methods and data associated with
//                generating an element/proc mapping for grid partitioning.
//                This class is meant to be an interface base clase  to all 
//                other map generator classes.
// Derived From : none.
// Modifications:
//************************************************************************************//
#if !defined(GPARTMAPPER_HPP)
#define GPARTMAPPER_HPP

#include "gtypes.h"
#include "gelemlist.hpp"
#include "gcomm.hpp"

#if !defined(PMDEFAULT_KEY)
#  define  PMDEFAULT_KEY  -1
#endif
#if !defined(PMDEFAULT_PROC)
#  define  PMDEFAULT_PROC -1
#endif

class GPartMapper 
{
public:
                           GPartMapper(GElemList *gelemsv);
                          ~GPartMapper();

virtual  GBOOL             GenerateMap(stGPartitionMap *&pm, GINT &nmax)=0;          // Generate partition map data
         GDOUBLE          *GetCurve(GINT &npoints);                                  // Get SFCurve and number points
         void              SetCoarsenables(GKEYBuffer *kcoarsen);                    // Set keys that will be coarsened
         void              SetDoCurve(GBOOL bset);                                   // Set flag to compute SFCurve

protected:

         GSHORT            nprocs_;
         GSHORT            this_rank_;
         GBOOL             bDoCurve_;
         GINT              gnelems_;
         GKEYBuffer        *kcoarsen_;
         GElemList         *gelems_; 
         GDOUBLE           *curve_;
         GC_DATATYPE        pm_type_;


};

#endif
