//************************************************************************************//
// Module       : iconn_amr.cpp
// Date         : 8/25/03 (DLR)
// Copyright    : 2003-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the access methods and data associated with
//                defining a simple (I)nterpolation-based (Conn)ectivity-type
//                (AMR) method.
// Derived From : GS (gather/scatter class) 
// Modifications:
//************************************************************************************//
#if !defined(ICONN_AMR_HPP)
#define ICONN_AMR_HPP

#include "gtypes.h"
#include <iostream.h>
#include <stdlib.h>
#include "gelemlist.hpp"
#include "gelemindex.hpp"
#include "gfieldlist.hpp"
#include "vdb.hpp"
#include "gtlist.hpp"
#include "gttlist.hpp"
#include "point.hpp"
#include "glop.hpp"
#include "gkeygen.hpp"
#include "gs.hpp"

#if 0
#if !defined(GELEM_INDEX_DEF)
#define GELEM_INDEX_DEF
struct stElemIndex {
GINT      i_elem;
GIBuffer  v_indices;
GIBuffer  vv_indices;
GIBuffer  e_indices;
};
#endif
#endif

class IConnAMR : public GS
{
public:
                           IConnAMR();
                           IConnAMR(GElemList *gelems);
                          ~IConnAMR();

         void              SetGlobalDomain(Point *domain, GINT  ndomain,
                                           GIBuffer &igPeriodicity     ); // Set points defining global domain
         void              SetDoJInterp(GBOOL bInterp);                   // Do interpolations, J?
         void              SetDoJtInterp(GBOOL bInterp);                  // Do interpolations, Jt?
         void              SetDoExchange(GBOOL bExch);                    // Do data exchange?
         void              SetKeyGen(GKeyGen *keygen);                    // Set mortar id generator
         void              SetSynch(GBOOL synch);                         // Do synch of mortar endpoints?
         void              DoProjection(GBOOL proj);                      // Do a projection?
         void              DoMult(GBOOL mult);                            // Use multiplicity in projection?
         void              PreMask(GBOOL mask);                           // Use mask before J?
         void              SetElements(GElemList *elems);                 // Initialize domain decomposition
         GBOOL             Init();                                        // Initialize domain decomposition
         GBOOL             GSOp(GVecList &veclist, G_OP op);              // Carry out GS operation
         GBOOL             DSOp(GVecList &veclist, G_OP op, GCHandle h) {
                           return GSOp(veclist, op); }                    // For backward compatibility                             
         GBOOL             Host2Mortar(GVecList &v);                      // Apply J^T
         GBOOL             Mortar2Host(GVecList &v);                      // Apply J
         void              SetCycle(GINT icycle);

protected:
         // Methods: 
         GBOOL             InitDB();                                      // Initialize DBs
         GBOOL             DoMortaring();                                 // Config mortars; do connectivity
         GBOOL             FindMortarIDs();                               // Creates mortar node ids for GlOp
         GBOOL             FindEdgeNeighbors(Point &v1, GINT  m1, Point &v2, GINT  m2,
                                             Point &mid, GINT  mm, GINT  md, 
                                             Point &pv1, Point &pv2, GBOOL bPeriodic[],
                                             GINT  hostid, GBOOL bGB, GNeighborList &eneighs);
         GBOOL             DoPeriodicMortars();
         void              ComputeMortarBdy(Point  &vj, Point &vk, GINT  jedge, GINT  mm, 
                                            Point &vP1, Point &vP2);
         GBOOL             WrapPeriodicVPoint(Point &vpt, GINT  ivert, Elem2D &elem);
         GBOOL             WrapPeriodicEPoint(Point &vpt, GINT  iedge, Elem2D &elem);
         void              RegularizeMortar(GDBuffer *xreg[], GMortar1D *mortar);


         // Member data
         GINT              nprocs_;            // number of procs
         GINT              nLocal_;            // number of local 'messages'
         GINT              maxmsg_;            // among all procs, the max msg length
         GINT              icycle_;            // cycle no.
         GNODEID           maxid_;             // max of all mortar node ids
         GINT              nglobDomain_;       // no. points specifying global domain
         GSHORT            this_rank_;         // local processor rank (id)
         GBOOL             bInitialized_;      // has Init completed successfully?
         GBOOL             bSynchMortars_;     // flag indicating whether to synch mortar endpoints
         GBOOL             bDoJInterp_;        // apply J matrices?
         GBOOL             bDoJtInterp_;       // apply  J^T matrices?
         GBOOL             bDoDataExch_;       // do data exchange?
         GBOOL             bProjection_;       // do a projection?
         GBOOL             bUseMult_;          // use multiplicity in projection?
         GBOOL             bPreMask_;          // use mask before J-application?
         GBOOL             bGlobalDomain_;     // has global domain been set?
         GDOUBLE           gdL_[GDIM];         // periodic box dimensions, if used
         GCHandle          hDSOp_;             // GlOp handle
         VDB               db_midpnt_;         // midpoint database
         VDB               db_vertex_;         // vertex database
         Point             *globDomain_;       // points defining global (rect) domain (used for bcs)
         GElemList         *gelems_;           // element list pointer
         GFieldList        *gfields_;          // field list pointer
         GNIDBuffer         mortarids_;        // 'flat' mortar node id array
         GIBuffer           bgPeriodicity_;    // global bdy faces periodicity flags
         GKeyGen           *keygen_;           // Morton ordering object
         GVector           flat_mortars_;      // 'flat' vector containing all mortar data
         GVector           *xm_[GDIM];         // mortar nodal points, for temp space
         GDBuffer          *xreg_[GDIM];       // regularized mortar nodal points, for temp space
         GlOp              *glop_;             // global gs operator

};

#endif
