//************************************************************************************//
// Module       : ntree_adapt.cpp
// Date         : 9/25/03 (DLR)
// Copyright    : 2003-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the access methods and data associated with
//                defining an N-tree-based adaption scheme.
// Derived From : IConnAMR
// Modifications:
//************************************************************************************//
#if !defined(NTREEADAPT_HPP)
#define NTREEADAPT_HPP

#include "gtypes.h"
#include <iostream.h>
#include <stdlib.h>
#include "iconn_amr.hpp"
#include "gelemlist.hpp"
#include "gfieldlist.hpp"
#include "gobjlist.hpp"
#include "gpartmapper.hpp"
#include "gpartitioner.hpp"

#if !defined(MAX_NEIGHBORS)
#  define MAX_NEIGHBORS (2*(GDIM-1))
#endif

#if !defined(REFINE_QUERY_DEF)
#define REFINE_QUERY_DEF
#define NRQUERYST_MEM 4
struct stRefineQuery{
GKEY   elem_key;
GKEY   parent_key;
GKEY   root_key;
GINT   iflag;
};
#endif

#define GNTREEADAPT_LEVEL(elemid,rootid_inv) ( (GINT)(1.660964047*log10(elemid*rootid_inv)+0.5) )

#if 0
#if !defined(COARSEN_QUERY_DEF)
#define COARSEN_QUERY_DEF
#define NCQUERYST_MEM 2
#define MAX_NUMFACES  ((GINT )pow(2.0,GDIM))
#define GMAX_NUMFACES (GDIM*GDIM)
struct stCoarsenQuery{
GKEY   child_key;
GINT   ien[GMAX_NUMFACES];
};
#endif
#endif


class NTreeAdapt: public IConnAMR
{
public:
                           NTreeAdapt(GINT  maxlev=4);
                           NTreeAdapt(GElemList *gelems, GFieldList *gfields[], GINT  nfields, GINT  maxlev=4);
                          ~NTreeAdapt();

         GBOOL             Adapt(GIBuffer  &hrefine, GIBuffer  &coarsen);           // Do refinement and coarsening
         void              DoLoadBalance(GBOOL bal);                                // Set/Get flag for load balancing
         void              DoPartitioning(GBOOL doit);                              // Set/Get flag for partioning of any kind
         void              SetFieldGroup(GElemList *elems, GFieldList *fields[], GINT  nfields); 
                                                                                    // Set fields/elements
         void              SetRefineDir(GINT  idir);                                // Set refinement direction
         void              SetLevelLimit(GINT  nlevel=0);                           // Don't refine beyond specified level
         void              SetPartitioner(GPartitioner *part);                      // Set grid partitioner object
         void              SetLoadBalanceMapper(GPartMapper *pmglobal);             // Set partition mapper object for load balancing

private:
         // Methods: 
         void              CheckConsistency(GIBuffer  &hrefine, GIBuffer  &coarsen);
         void              CheckRefinement (GIBuffer  &hrefine, GIBuffer  &coarsen);
         void              CheckCoarsening (GIBuffer  &hrefine, GIBuffer  &coarsen);
         GBOOL             AdaptAll(GIBuffer  &hrefine, GIBuffer  &coarsen); 
//       GBOOL             AdaptElemental  (GIBuffer  &hrefine, GIBuffer  &coarsen);
         GBOOL             DoRefinement(GIBuffer &irefine);
         GBOOL             DoCoarsening(GIBuffer &icoarsen);
         GBOOL             DoPartition(GIBuffer &icoarsen, GKEYBuffer  &kcoarsen, GPartMapper *pm);
         GBOOL             RefineElemental(Elem2D *parent_elem, Field2D *parent_field[], GElemList *gelems, GFieldList *gfields[], GINT nfields);
         GBOOL             CoarsenElemental(Elem2D *esiblings[], GINT  nsiblings, Elem2D *& p_elem, GElemList *gelems, GFieldList *gfields[], GINT nfields);
         void              GetSiblings(Elem2D *e, Elem2D **&esiblings, GINT  &nsiblings,
                                       GElemList *gelems);
         void              EPointersToIndices(GIBuffer  &ibuff, Elem2D *pelem[], GINT  npelem);
         void              Restrict2OneSibMem(GIBuffer &outind, GKEYBuffer &inkeys);


         GKEY              ParentKey(Elem2D *elem);
         GKEY              ParentKey(GKEY rkey, GKEY ckey);
         GKEY              ChildKey (Elem2D *elem, GINT ichild);
         GINT              RefineLevel(Elem2D *elem);
         GINT              RefineLevel(GKEY rkey, GKEY ckey);
         void              ElemIndexToKey(GKEYBuffer &kbuff, GIBuffer &ibuff);
         GBOOL             SetChildVertices(Elem2D  *parent, Elem2D  *child, GINT  ichild);
         GBOOL             SetChildBdy     (Field2D *parent, Field2D *child, GINT  ichild);
         GBOOL             SetParentVertices(Elem2D  *esib[], GINT  nsib, Elem2D  *parent);
         GBOOL             SetParentBdy     (Field2D *fsib[], GINT  nsib, Field2D *parent);
         GBOOL             ReorderSiblings  (Elem2D *esiblings[], GINT  nsiblings);
         GBOOL             CheckPeriodic(GINT  &i, GINT  &j);
         GBOOL             InQueryList(stRefineQuery *lquery, GINT  nquery, GKEY key, 
                                       GINT  *isrch, GINT  nsrch);
         GINT              NumberSiblings(stRefineQuery lquery[], GINT  nquery, GKEY pkey);
         GINT              ElemKeyToIndex(GIBuffer &index, GKEYBuffer &key);
         GINT              AllSibsCoarsened(GIBuffer  &coarsebuff, GINT  *isrch, GINT  nsrch, GIBuffer  &ikeepbuff);

         void              OrderLevelDecreasing(GIBuffer  &buff, GINT  &nglevel);
         void              GetLevelRanges(GIBuffer  &ibeg, GIBuffer  &iend, GIBuffer  &buff, GINT  &nglevel);
         GINT              BuildGQueryList(stRefineQuery *&gquerylist, GINT  &nqlist, GIBuffer  &rclist, 
                                           GINT  *isrch, GINT  nsrch);


         // Member data
         GSHORT            nprocs_;            // total number of processors
         GSHORT            this_rank_;         // the rank of this processor
         GBOOL             bDoLoadBalance_;    // flag indicating that load balancing is to be done
         GBOOL             bPartitioning_;     // flag indicating that partitioning is to be done
         GBOOL             bLimitByLevel_ ;    // is there a refine. level limit?
         GINT              ndcomp_;            // number of sibling decompositions
         GINT              nlevel_limit_;      // if bLimitByLevel_=TRUE, how many refine. levels allowed?
         GINT              nfields_;           // number of fields on primary grid
         GINT              dcomp_dir_;         // refinement direction (or 0 for refinement in all)
         GINT              max_levels_;        // max no. of refinement levels
         GINT              npart_;             // max no. of partition sends for each proc
         GKEY              max_key_mult_;      // max change in id from root 
         GDOUBLE           indcomp_;           // inverse of number of sibling decompositions
         GC_DATATYPE       refq_type_;         // Refine query data type for communications
         GFieldList        **gfields_;         // Fields on primary grid
         GFGList           fieldgroups_;       // field group list
         GPartitioner      *partitioner_;      // field group list
         stGPartitionMap   *partmap_;          // partition map structure
         GPartMapper       *pmglobal_;         // partition mapper for global load balancing
         GPartMapper       *pmsibling_;        // partiaion mapper for sibling collection/partitioning

};


#endif
