//************************************************************************************//
// Module       : vdb.hpp
// Date         : 8/5/03 (DLR)
// Copyright    : 2003-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                a voxel database object
// Derived From : none.
// Modifications:
//************************************************************************************//
#if !defined(VDB_HPP)
#define VDB_HPP

#include "gtbuffer.hpp"
#include "gtlist.hpp"
#include "gkeygen.hpp"


#if !defined(GVDB_STRUCT)
#define GVDB_STRUCT
#define NVDBST_MEM 6
#define NULL_HOSTKEY -1
struct GVDBst {
  GKEY  hostkey;
  GKEY  hostrootkey;
  GINT  hostid;
  GINT  id;
  GINT  ancillary;
  GDOUBLE x    [GDIM];
};
#endif

class VDB 
{
public:
                  VDB();
                 ~VDB();
                  VDB(const VDB &a);

void              add(Point3D *point, GKEY *key,  GKEY *hostkey, 
                      GKEY *hostrootkey, GINT  *localid, GINT  *ancillary, GINT  *hostid,
                      GSHORT  *iproc, GINT  num=1);                              // add entries
GBOOL             del(Point3D *point, GINT  num=1);                             // delete entries
GBOOL             del(GKEY    *key  , GINT  num=1);                             // delete entries
GINT              size();                                                       // total number of records
GINT              multiplicity(Point3D *point);                                 // get multiplicity of point
GINT              multiplicity(GKEY *key);                                      // get multiplicity of key
void              multiplicity(Point3D *point, GINT  *&mult, GINT  num=1);      // get multiplicity of point array
void              multiplicity(GKEY    *hostkey  , GINT  *&mult, GINT  num=1);  // get multiplicity of key array
void              procs(Point3D *point, GSBuffer   **&iprocs, GINT  num=1);     // get proc list for point
void              procs(GKEY     *hostkey , GSBuffer   **&iprocs, GINT  num=1); // get proc list for key
void              synch       ();                                               // synch VBD on all processors
VDBData          *record(GINT  irec);                                           // get record via local index
VDBData          *record(Point3D &point, VDBData **&vdbelems, GINT  &num);      // get record(s) by point
VDBData          *record(GKEY    &key  , VDBData **&vdbelems, GINT  &num);      // get record(s) by key
GBOOL             duplicates(VDBData &rec, GINT  *&indices, GINT  &num);        // get indices of duplicate records
void              SetKeyGen(GKeyGen *keygen);                                   // Set key-generator object
void              CleanAll();                                                   // Remove all data from DB
void              Bracket(GDOUBLE eps);                                           // Set fuzziness in points
friend ostream&   operator<<(ostream&, VDB &);                                  // Output stream operator


private:
// Private methods:
void              CleanNonLocal();                                              // Remove non-local data from DB
 

// Private data:
GSHORT             nprocs_;                         // number of processors
GSHORT             this_rank_;                      // rank of current processor
GDOUBLE            eps_;                            // fuzziness in point positions, for comparing
VDBList            vdb_list_;                       // list of vdb data elements
GKeyGen            *keygen_;                        // key-generator object
GC_DATATYPE        vdbst_type_;                     // GVDBst data type for communications

};
#endif

