//======================================================================================
// Name         : gaspar_t.h
// Date         : 9/10/02 (DLR)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : GASpAR main driver header file
// Modifications:
//======================================================================================

#include "gtypes.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <iostream.h>
#include <fstream.h>
#include <math.h>
#include <unistd.h>
#include "gllbasis.hpp"
#include "glbasis.hpp"
#include "rectquad2d.hpp"
#include "pcblockjac_helm.hpp"
#include "pcblockjac_lap.hpp"
#include "timer.h"
#include "mtk.hpp"
#include "ns.hpp"
#include "burgers.hpp"
#include "gllbasis.hpp"
#include "glbasis.hpp"
#include "glop.hpp"
#include "gtlist.hpp"
#include "gtlistarray.hpp"
#include "gttlist.hpp"
#include "mesh_reader.hpp"
#include "gbin_writer.hpp"
#include "gbin_reader.hpp"
#include "gcomm.hpp"
#include "gutils.hpp"
#include "gtbuffer.hpp"
#include "param_reader.hpp"
#include "apost_error.hpp"
#include "morton_keygen.hpp"
#include "glogger.hpp"
#include "point.hpp"
#include "gobjbuffer.hpp"
#include "gpartitioner.hpp"
#include "gpmelemid.hpp"
#include "gifilter.hpp"
//#include "hdfFile.hpp"
#if defined(MPI_GENERIC_DEFAULT)
#  include "mpi.h"
#endif

enum         GSVAR               {GSV1=0, GSV2, GSV3, GSP, GSV1B, GSV2B, GSV3B};
enum         GERROR              {GERR_NONE=0, GERR_STEP, GERR_TIMESTEP, GERR_DUMP, GERR_ADAPT, GERR_OUT, GERR_LOG};
//char         *sGError_[]=        {"Err:Normal", "Err:Step", "Err:Timestep", "Err:Dump", "Err_Adapt", "Err:Output", "Err:Log"};

#if defined(_GASPAR_H_INIT)

GINT         rank              = 0;
GINT         nproc             = 0;
GINT         nd_               = 2;
GINT         nEvolvedFields_   = 1;
GINT         naPostFields_     = 1;
GINT         nUserFields_      = 0;
GINT         Ne[]              = {2,2,0};
GINT         xN[]              = {8,8,0};
GINT         u1iter            = 1024;
GINT         u2iter            = 1024;
GINT         piter             = 1024;
GINT         nBdyCond_         = 0   ;
GINT         ngVertices_       = ((GINT )pow(2.0,GDIM));
GINT         *iadv_            = NULL;
GINT         nadv_             = 0;
GINT         nuserdynamiclog_  = 0;
GINT         nuserstaticlog_   = 0;
GERROR       iGError_          = GERR_NONE;
STOPCONDTYPE iStopCond_        = BY_CYCLE ;
STOPCONDTYPE iAMRCond_         = BY_CYCLE ;
STOPCONDTYPE iLBalCond_        = BY_CYCLE ;
OUTPUTTYPE   iOutType_         = OUT_BIN;  //OUT_SDS;
GINT         iEvolType_        = 0;
GINT         nvert_            = ((GINT )pow(2.0,(GSHORT)nd_));
GINT         ndmpmeta_         = 35;
GINT         icycle_           = 0;
GINT         icycle_max_       = 1   ;
GINT         icycle_out_beg_   = 0   ;
GINT         icycle_out_end_   = 100000 ;
GINT         icycle_out_skip_  = 1   ;
GINT         icycle_out_last_  = 0   ;
GINT         icycle_dmp_beg_   = 0   ;
GINT         icycle_dmp_skip_  = 100 ;
GINT         icycle_dmp_last_  = 0   ;
GINT         icycle_log_skip_  = 100 ;
GINT         icycle_log_last_  =   0 ;
GINT         icycle_amr_beg_   =   0 ;
GINT         icycle_amr_skip_  =  10 ;
GINT         icycle_amr_last_  =   0 ;
GINT         icycle_lbal_beg_  =   0 ;
GINT         icycle_lbal_skip_ =   1 ;
GINT         icycle_lbal_last_ =   1000000;
GNODEID      vmaxid                  ;
GNODEID      pmaxid                  ;
GINT         nelems_           = 1;
GINT         ngelems_          = 1;
GINT         iorderadv_        = 3 ;
GINT         iorderAM_         = 3 ;
GINT         iorderBDF_        = 2 ;
GINT         ntimelevels_      = 3 ;
GINT         ntmplevels_       = 3 ;
GINT         nrefinelevels_    = -1;
GINT         gndofs_           = 0;
GINT         ncourflds_        = 0;
GINT         *ncgit_           = NULL;
GINT         *gncgit_          = NULL;
GINT         nSpFit_           = 4;
GINT         filter_delta_     = 1;
GBOOL        bUPC              = TRUE;
GBOOL        bPPC              = TRUE;
GBOOL        bExtMesh          = FALSE;
GBOOL        bStepError_       = FALSE;
GBOOL        bConvError_       = FALSE;
GBOOL        bAdaptError_      = FALSE;
GBOOL        bRestart_         = FALSE;
GBOOL        bRegrid_          = FALSE;
GBOOL        bFixedTimeStep_   = FALSE;
GBOOL        bScaledTimeStep_  = FALSE;
GBOOL        bDoAdapt_         = TRUE;
GBOOL        bDoCoarse_        = TRUE;
GBOOL        bReadCmdFile_     = TRUE;
GBOOL        bDoAdvection_     = TRUE;
GBOOL        bLinAdvection_    = FALSE;
GBOOL        bOutOnGridChange_ = TRUE;
GBOOL        bElemListChange_  = FALSE;
GBOOL        bAutoTimeLevelFill_= TRUE;
GBOOL        bTimeDepBdy_      = FALSE;
GBOOL        bPGrid_           = FALSE;
GBOOL        bSpectralAP_      = TRUE;
GBOOL        b1DerivativeAP_   = TRUE;
GBOOL        b2DerivativeAP_   = TRUE;
GBOOL        bDoLoadBalancing_ = FALSE;
GBOOL        bFilter_          = FALSE;
GBOOL        bDoDealiasing_    = FALSE;
GBOOL        bScaleBySize_     = FALSE;
GDOUBLE      Courant_          = 0.5;
GDOUBLE      dt_               = 0.0;
GDOUBLE      dtMin_            = 1.0e-9;
GDOUBLE      divvmax_          = 0.0;
GDOUBLE      time_             = 0.0;
GDOUBLE      time_max_         = 0.0;
GDOUBLE      time_out_beg_     = 0.0 ;
GDOUBLE      time_out_end_     = 1.0e6 ;
GDOUBLE      time_out_skip_    = 0.1 ;
GDOUBLE      time_out_last_    = 0.0 ;
GDOUBLE      time_amr_beg_     = 0.0 ;
GDOUBLE      time_amr_skip_    = 0.1 ;
GDOUBLE      time_amr_last_    = 0.0 ;
GDOUBLE      time_lbal_beg_    = 0.0 ;
GDOUBLE      time_lbal_skip_   = 0.0 ;
GDOUBLE      time_lbal_last_   = 0.0 ;
GDOUBLE      nu_[GDIM]               ;
GDOUBLE      rho_              = 1.0   ;
GDOUBLE      aux_              = 0.0   ;
GDOUBLE      aux0_             = 0.0   ;
GDOUBLE      aux1_             = 0.0   ;
GDOUBLE      gMinElemLength_   = 1.0;
GDOUBLE      gMaxElemLength_   = 1.0;
GDOUBLE      ap_tol_           = 1.0e-5;   // tolerance for spectral error
GDOUBLE      ap_tol1_          = 1.0   ;   // tolerance for 1-derivative
GDOUBLE      ap_tol2_          = 1.0   ;   // tolerance for 2-derivative
GDOUBLE      sig_tol_          = 0.7;      // tolerance for min. Legendre decay rate
GDOUBLE      cor_tol_          = 0.5;      // tolerance for min. correlation coeff
GDOUBLE      cor_mult_tol_     = 0.95;     // tolerance for coarsening for correl. coeff
GDOUBLE      ap_mult_          = 1.0e-2;   // coarsen multiplier spectral error
GDOUBLE      ap_mult1_         = 1.0e-2;   // coarsen multiplier for 1-derivative
GDOUBLE      ap_mult2_         = 1.0e-2;   // coarsen multiplier for 2-derivative
GDOUBLE      sig_mult_         = 2.0;      // coarsen multiplier for min. Legendre decay rate
GDOUBLE      u1tol             = 1.0e-10;
GDOUBLE      u2tol             = 1.0e-10;
GDOUBLE      ptol              = 1.0e-10;
GDOUBLE      P0_   [2]         = {0.0, 0.0};
GDOUBLE      P1_   [2]         = {1.0, 1.0};
GDOUBLE      B0_[4][2]         = {{0.0,0.0},{1.0,0.0},{1.0,1.0},{0.0,1.0}};
GDOUBLE      B1_[4][2]         = {{1.0,0.0},{1.0,1.0},{0.0,1.0},{0.0,0.0}};
GDOUBLE      TCOut_            = 0.0;
GDOUBLE      TWOut_            = 0.0;
GDOUBLE      TCLog_            = 0.0;
GDOUBLE      TWLog_            = 0.0;
GDOUBLE      TCDmp_            = 0.0;
GDOUBLE      TWDmp_            = 0.0;
GDOUBLE      gLoadBalMeas_     = 0.0;
BDYTYPE      btype_[4]         = {PERIODIC, DIRICHLET, PERIODIC, DIRICHLET};
//BDYTYPE      btype_[4]         = {NONE, DIRICHLET, NONE, DIRICHLET};
# if 0
GDOUBLE      P0_   [2]         = {-0.5,-0.5};
GDOUBLE      P1_   [2]         = {1.0, 1.5};
GDOUBLE      B0_[4][2]         = {{-0.5,-0.5},{1.0,-0.5},{1.0,1.5},{-0.5,1.5}};
GDOUBLE      B1_[4][2]         = {{1.0,-0.5},{1.0,1.5},{-0.5,1.5},{-0.5,-0.5}};
BDYTYPE      btype_[4]         = {DIRICHLET,DIRICHLET,DIRICHLET,DIRICHLET};
#endif
GDOUBLE       Pi                = 4.0*atan(1.0);
GDOUBLE       *errcg_           = NULL;
GDOUBLE       *gerrcg_          = NULL;
GDOUBLE       filter_alpha_     = 0.0;
GPC           upc_type_         = GPC_POINTJAC_HELM;
STOKES_TYPE   stokes_type_      = STOKES_SCHUR_DELP;
Point         *gd_              = NULL;
Point         *dX_              = NULL;
Morton_KeyGen *morton_         = NULL;
GPartitioner  *partitioner_    = NULL;
GPartMapper   *partmapper_     = NULL;
GElemList     uelems                 ;
GElemList     pelems                 ;
GElemList     *usergrid_       =&uelems;
GElemList     poldElements           ;
GElemListArray gusergrids_           ;
GFieldList    u1                     ;
GFieldList    u2                     ;
GFieldList    u3                     ;
GFieldList    p                      ;
GFieldList    **pgfields_      = NULL;
//GFieldList    **pufields_      = NULL;
GFieldList    **pafields_      = NULL;
GFieldList    *cadv_    [3]={NULL,NULL,NULL};
GFieldList    *courflds_[3]={NULL,NULL,NULL};
GFieldListArray pufields_            ;
GFGList       fieldgroups_           ;
GLinOpList    *filter_ = NULL        ;

GNIDBuffer   *vnode_ids        = NULL;
GETBuffer    *velemtypes       = NULL;
GIBuffer      glldegrees_            ;
GIBuffer      gldegrees_             ;
GIBuffer      hrefine_               ;
GIBuffer      hcoarse_               ;
GIBuffer      igPeriodic_            ;
GIBuffer      iBasisTypes_           ;
GIBuffer      igNumElems_            ;
GDBuffer      apunorm_               ;
GDBuffer      dunorm_                ;
GDBuffer      dthist_                ;
GDBuffer      fgPeriodic_            ;
IBuffList     bdyindices             ;
GVecList      u1bdyvals              ;
GVecList      u2bdyvals              ;
GVecList      u3bdyvals              ;
GVecList      **pgbdyvals_     = NULL;
GVecList      utmp                   ;
GVecList      uptmp                  ;
GVecList      ptmp                   ;
BTBuffList    bdytype                ;
//GLLBasis     *gllbasis[GDIM]   = {NULL};
//GLLBasis     *gllbasis32[GDIM] = {NULL};
//GLBasis      *glbasis [GDIM]   = {NULL};
GTBasisListGLL gllpool_               ; 
GTBasisListGLL gllpool32_             ; 
GTBasisListGL  glpool_                ;
GCHandle      hDSOp            = NULL_HANDLE;
NTreeAdapt   *glop             = NULL;
GLogger       glogger_;
#if defined(BURGERS)
GINT          nAdvDirs_        = 1;
GINT          iAdvDirs_[3]     = {1, 0, 0};
GINT          nsi_force_       = 0;
SI_FORCE_TYPE si_force_type_[] = {SI_EV};
char          *sforce_blk_[]   = {"EVFORCE_BLOCK"};
BurgersSolver *stepper         = NULL;
#else
NavierStokes  *stepper         = NULL;
#endif
char          *sPCType    [] = {"GPC_BLOCKJAC_HELM","GPC_BLOCKJAC_LAP","GPC_POINTJAC_HELM","GPC_NONE"};
//char         *sDSLabel    [] = {"V1","V2","V3","Pr","V1B","V2B","V3B"};
char         **sDSLabel_     = NULL;
GStringList  sUDSLabel_            ;
char         *sCAdvLabel  [] = {"C1","C2","C3"};
char         sDSLabel_suff[] = "_T";
char         *sSpNLabel_     = "SP_NORM";
char         *sDerivNLabel_  = "D2_NORM";
char         *sTHLabel_      = "DT_HISTORY";
char         *sPBLabel_      = "bPERIODIC";
char         *serrmsg                       ;
char         sgdd_  [MAX_GDD_STRING+1]={"\0"};
char         fnmesh_[FILE_NAME_MAX+1]={"\0"};
char         fnuser_[FILE_NAME_MAX+1]={"\0"};
char         fncmd_[FILE_NAME_MAX+1]={"\0"};
char         fnlog_ [FILE_NAME_MAX+1]={"\0"};
char         fnout_[FILE_NAME_MAX+1]={"\0"};
char         fndmp_[FILE_NAME_MAX+1]={"\0"};
char         fnrst_[FILE_NAME_MAX+1]={"\0"};
char         suserblk_[FILE_NAME_MAX+1]={"\0"};
char         main_blk_[FILE_NAME_MAX+1]={"GASpAR_MAIN"};
char         aux_blk_[FILE_NAME_MAX+1]={"GASpAR_AUX"};


#else

extern GINT         rank            ;
extern GINT         nproc           ; 
extern GINT         nd_             ; 
extern GINT         nEvolvedFields_ ;
extern GINT         naPostFields_   ;
extern GINT         nUserFields_    ;
extern GINT         Ne[]            ; 
extern GINT         xN[]            ; 
extern GINT         uiter           ; 
extern GINT         piter           ; 
extern GINT         nBdyCond_       ; 
extern GINT         ngVertices_     ;
extern GINT         *iadv_          ;
extern GINT         nadv_           ;
extern GINT         nuserdynamiclog_;
extern GINT         nuserstaticlog_ ;
extern GERROR       iGError_        ;
extern GINT         nuserlog_       ;
extern STOPCONDTYPE iStopCond_      ;
extern STOPCONDTYPE iAMRCond_       ;
extern STOPCONDTYPE iLBalCond_      ;
extern OUTPUTTYPE   iOutType_       ;
extern GINT         iEvolType_     ;
extern GINT         nvert_          ;
extern GINT         ndmpmeta_       ;
extern GINT         icycle_         ; 
extern GINT         icycle_max_     ;
extern GINT         icycle_out_beg_ ; 
extern GINT         icycle_out_end_ ; 
extern GINT         icycle_out_skip_; 
extern GINT         icycle_out_last_;
extern GINT         icycle_dmp_beg_ ; 
extern GINT         icycle_dmp_skip_;
extern GINT         icycle_dmp_last_;
extern GINT         icycle_log_skip_;
extern GINT         icycle_log_last_;
extern GINT         icycle_amr_beg_ ;
extern GINT         icycle_amr_skip_;
extern GINT         icycle_amr_last_;
extern GINT         icycle_lbal_beg_ ;
extern GINT         icycle_lbal_skip_;
extern GINT         icycle_lbal_last_;
extern GNODEID      vmaxid          ;
extern GNODEID      pmaxid          ;
extern GINT         nelems_         ;
extern GINT         ngelems_        ;
extern GINT         iorderadv_      ;
extern GINT         iorderAM_       ;
extern GINT         iorderBDF_      ;
extern GINT         ntimelevels_    ;
extern GINT         ntmplevels_     ;
extern GINT         nrefinelevels_  ;
extern GINT         *ncgit_         ;
extern GINT         *gncgit_        ;
extern GINT         gndofs_         ;
extern GINT         ncourflds_      ;
extern GINT         nSpFit_         ;
extern GINT         filter_delta_   ;
extern GBOOL        bUPC            ;
extern GBOOL        bPPC            ;
extern GBOOL        bExtMesh        ;
extern GBOOL        bStepError_     ;
extern GBOOL        bConvError_     ;
extern GBOOL        bAdaptError_    ;
extern GBOOL        bRestart_       ;
extern GBOOL        bRegrid_        ;
extern GBOOL        bFixedTimeStep_ ;
extern GBOOL        bScaledTimeStep_;
extern GBOOL        bDoAdapt_       ;
extern GBOOL        bDoCoarse_      ;
extern GBOOL        bReadCmdFile_   ;
extern GBOOL        bDoAdvection_   ;
extern GBOOL        bLinAdvection_  ;
extern GBOOL        bOutOnGridChange_;
extern GBOOL        bElemListChange_;
extern GBOOL        bAutoTimeLevelFill_;
extern GBOOL        bTimeDepBdy_    ;
extern GBOOL        bPGrid_         ;
extern GBOOL        bSpectralAP_    ;
extern GBOOL        b1DerivativeAP_ ;
extern GBOOL        b2DerivativeAP_ ;
extern GBOOL        bDoLoadBalancing_;
extern GBOOL        bFilter_        ;
extern GBOOL        bDoDealiasing_  ;
extern GBOOL        bScaleBySize_   ;
extern GDOUBLE      Courant_        ;
extern GDOUBLE      dt_             ;
extern GDOUBLE      dtMin_          ;
extern GDOUBLE      divvmax_        ;
extern GDOUBLE      time_           ;
extern GDOUBLE      time_max_       ;
extern GDOUBLE      time_out_beg_   ;
extern GDOUBLE      time_out_end_   ;
extern GDOUBLE      time_out_skip_  ;
extern GDOUBLE      time_out_last_  ;
extern GDOUBLE      time_amr_beg_   ;
extern GDOUBLE      time_amr_skip_  ;
extern GDOUBLE      time_amr_last_  ;
extern GDOUBLE      time_lbal_beg_  ;
extern GDOUBLE      time_lbal_skip_ ;
extern GDOUBLE      time_lbal_last_ ;
extern GDOUBLE      nu_[]           ;
extern GDOUBLE      rho_            ;
extern GDOUBLE      aux_            ;
extern GDOUBLE      aux0_           ;
extern GDOUBLE      aux1_           ;
extern GDOUBLE      gMinElemLength_ ;
extern GDOUBLE      gMaxElemLength_ ;
extern GDOUBLE      ap_tol_         ;
extern GDOUBLE      ap_tol1_        ;
extern GDOUBLE      ap_tol2_        ;
extern GDOUBLE      sig_tol_        ;
extern GDOUBLE      cor_tol_        ;
extern GDOUBLE      cor_mult_tol_   ;
extern GDOUBLE      ap_mult_        ; 
extern GDOUBLE      ap_mult1_       ; 
extern GDOUBLE      ap_mult2_       ; 
extern GDOUBLE      sig_mult_       ;
extern GDOUBLE      u1tol           ;
extern GDOUBLE      u2tol           ;
extern GDOUBLE      ptol            ;
extern GDOUBLE      P0_   []        ;
extern GDOUBLE      P1_   []        ;
extern GDOUBLE      **B0_           ;
extern GDOUBLE      **B1_           ;
extern GDOUBLE      TCOut_          ;
extern GDOUBLE      TWOut_          ;
extern GDOUBLE      TCLog_          ;
extern GDOUBLE      TWLog_          ;
extern GDOUBLE      TCDmp_          ;
extern GDOUBLE      TWDmp_          ;
extern GDOUBLE      gLoadBalMeas_   ;
extern GDOUBLE      Pi              ;
extern GDOUBLE      *errcg_         ;
extern GDOUBLE      *gerrcg_        ;
extern GDOUBLE      filter_alpha_   ;
extern BDYTYPE      btype_[]        ;
extern GPC          upc_type_       ;
extern STOKES_TYPE  stokes_type_    ;
extern Point        *gd_            ;
extern Point        *dX_            ;
extern Morton_KeyGen *morton_       ;
extern GPartitioner  *partitioner_  ;
extern GPartMapper   *partmapper_   ;
extern GElemList     uelems         ;
extern GElemList     pelems         ;
extern GElemList     *usergrid_     ;
extern GElemList     poldElements   ;
extern GElemListArray   gusergrids_ ;
extern GFieldList   u1              ;
extern GFieldList   u2              ;
extern GFieldList   u3              ;
extern GFieldList   p               ; 
extern GFieldList   **pgfields_     ;
//extern GFieldList   **pufields_     ;
extern GFieldList   **pafields_     ;
extern GFieldList   *cadv_    []    ;
extern GFieldList   *courflds_[]    ;
extern GFieldListArray pufields_    ;
extern GFGList      fieldgroups_    ;
extern GLinOpList   *filter_        ;
extern GNIDBuffer   *vnode_ids      ; 
extern GETBuffer    *velemtypes     ; 
extern GIBuffer      glldegrees_    ;
extern GIBuffer      gldegrees_     ;
extern GIBuffer      hrefine_       ;
extern GIBuffer      hcoarse_       ;
extern GIBuffer      igPeriodic_    ;
extern GIBuffer      iBasisTypes_   ;
extern GIBuffer      igNumElems_    ;
extern GDBuffer      apunorm_       ;
extern GDBuffer      dunorm_        ;
extern GDBuffer      dthist_        ;
extern GDBuffer      fgPeriodic_    ;
extern IBuffList     bdyindices     ; 
extern GVecList      u1bdyvals      ; 
extern GVecList      u2bdyvals      ; 
extern GVecList      u3bdyvals      ; 
extern GVecList      **pgbdyvals_   ;
extern GVecList      utmp           ;
extern GVecList      uptmp          ;
extern GVecList      ptmp           ;
extern BTBuffList    bdytype        ;  
//extern GLLBasis     *gllbasis[]     ;
//extern GLLBasis     *gllbasis32[]   ;
//extern GLLBasis     *glbasis []     ;
extern GTBasisListGLL gllpool_      ; 
extern GTBasisListGLL gllpool32_    ; 
extern GTBasisListGL  glpool_       ;
extern GCHandle       hDSOp         ;
extern NTreeAdapt     *glop           ; 
extern GLogger       glogger_       ;
#if defined(BURGERS) 
extern GINT          nAdvDirs_      ;
extern GINT          iAdvDirs_[]    ;
extern GINT          nsi_force_     ;
extern SI_FORCE_TYPE si_force_type_[];
extern char          *sforce_blk_[] ;
extern BurgersSolver *stepper       ;
#else
extern NavierStokes *stepper        ;
#endif
extern char         sgdd_  []       ;
extern char         fnout_[]        ;
extern char         fnuser_[]       ;
extern char         fncmd_[]        ;
extern char         fndmp_[]        ;
extern char         fnrst_[]        ;
extern char         fnlog_[]        ;
extern char         fnmesh_[]       ;
extern char         *sPCType []     ;
extern char         **sDSLabel_     ;
extern GStringList  sUDSLabel_      ;
extern char         *sCAdvLabel[]   ;
extern char         sDSLabel_suff[] ;
extern char         *sSpNLabel_     ;
extern char         *sDerivNLabel_  ;
extern char         *sTHLabel_      ;
extern char         *sPBLabel_      ;
extern char         *serrmsg        ;
extern char         suserblk_[]     ;
extern char         main_blk_[]     ;
extern char         aux_blk_[]      ;

#endif

GBOOL GUserInit       (int argc, char *argv[]);
GBOOL GUserStart      ();
GBOOL GUserTimeDep    (GDOUBLE ptime, GDOUBLE pdt);
GBOOL GUserLogConfig  ();
GBOOL GUserLogUpdate  ();
GBOOL GUserTerm       ();
GBOOL GUserConfig     ();
GBOOL GAdaptGrid      ();
GBOOL GTagSpectral    (GIBuffer &hr, GIBuffer &hc);
GBOOL GTag1Deriv      (GIBuffer &hr, GIBuffer &hc);
GBOOL GTag2Deriv      (GIBuffer &hr, GIBuffer &hc);
GBOOL GInitMesh       ();
GBOOL GInitTimeLevels ();
GBOOL GCreateVar      ();
GBOOL GCreateFieldArrays();
GBOOL GCreateStepper  ();
GBOOL GSetBdyCond     ();
GBOOL GGlobalizeBdy   ();
GBOOL GGlobalAssembly ();
GBOOL GResetExpandables();
GBOOL GDump           (const char *fn, GBOOL deleteFirst);
GBOOL GRestart        ();
GBOOL GStep           ();
GBOOL GInit           (int argc, char *argv[]);
GBOOL GSetKeyGen      ();
GBOOL GInitGS         ();
GBOOL GInitLogger     ();
GBOOL GTimeStep       (GINT ilevel=0);
GBOOL GCourantTimeStep(GINT ilevel=0);
GBOOL GScaledTimeStep ();
GBOOL GOutCond        ();
GBOOL GAMRCond        ();
GBOOL GLBalCond       ();
GBOOL GStopCond       ();
GBOOL GDoLog          (GINT num, char *smsg, ...);
GBOOL GInitNorms      ();
void  GDeleteDynamic  ();
void  GWrapup         ();
GBOOL GCmdLineParse   (int argc, char *argv[]);
GBOOL GCmdFileParse   ();
GBOOL GTimeUpdate     ();
void GUpdateTimestepHistory(GDOUBLE dtp);
GINT  GRegisterUserFields(GINT numspecs, GFieldList *u1, char *su1, ...);
GINT  GSetAPostFields (GINT numfields, GFieldList *f1, ...);
void  GPrtHelp        (GSHORT argc, char **argv, ostream &pout);


GBOOL GOutput         ();
GBOOL GOutBin         ();
GBOOL GOutSDS         ();
GBOOL GPutSDS         (char *,GFieldList &);

void  GSetUserGrid(GElemList *elems);
GBOOL GSetGridFromFile(GBinReader &rgbin);
GBOOL GSetFieldVar(GBinReader &rgbin, char *dslabel, GNBasis *b[],  Field2D *field, GINT  iLev, GINT  &nfldnodes, GINT  &ninterp);
GBOOL GSetVarDataA(GBinReader &rgbin, char *dslabel, GDOUBLE *data, GINT ndata);
GBOOL GSetVarDataB(GBinReader &rgbin, char *dslabel, GDBuffer &dbuff);
GBOOL GSetSystemVar(GBinReader &rgbin, GINT  &num);
GBOOL GInterpData(GINT  rank, GNBasis *b[],  GVector &u, GVector *xi[], GVector *ui);
void  GComputeLoadBal();
GBOOL GCollectInterpPts(GINT  rank, Elem2D *e, GINT  nvert, Point3D *vert,
                       GNBasis *b[], GVector *xi[], GIBuffer  *ii);
GBOOL GPoint_in_region(GINT  nVertices, Point3D *spVertices, GDOUBLE x, GDOUBLE y);
GBOOL GbOverlap(Point3D *v1, Point3D *v2, GINT  nvert, GBOOL &bEqual);
GBOOL GXToXi(GINT  nVertices, Point3D spVertices[], GNBasis &basis1, GNBasis &basis2,
            GINT  num, GDOUBLE *ax1, GDOUBLE *ax2, GDOUBLE *xi1, GDOUBLE *xi2);
#if 0
GBOOL GErrChk();
#endif

