//======================================================================================
// Name         :   gbin_info.cpp
// Date         :   7/10/02 (DLR)
// Description  :   Provides GBin type file info 
// Modifications:
//======================================================================================
#include "gtypes.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <iostream.h>
#include <fstream.h>
#include <math.h>
#include "gbin_reader.hpp"
#include "gtvector.hpp"


GBOOL PrtInfo(char *filename, ostream &out);
GBOOL CmdLineParse(int argc, char *argv[]);


int main(int argc, char* argv[])
{

  if ( !CmdLineParse(argc, argv) ) {
    cout << argv[0] << ": Command line parse error" << endl;
    exit(1) ;
  }

  if ( argc < 2 ) {
    cout << "Enter:" << endl;
    cout << "     " << argv[0] << " file1 file2 file3 ... " << endl;
    exit(1);
  }
  GINT  i;

  for ( i=1; i<argc; i++ )
  {
    if ( !PrtInfo(argv[i], cout) )
    {
      cout << argv[0] << ":: Cannot get file info for file named " << argv[i] << endl;
      exit(1);
    }
  }

  exit(0);
  
} 

//************************************************************************************
// METHOD     : PrtInfo 
// DESCRIPTION:
// ARGUMENTS  :
// RETURNS    :
//************************************************************************************
GBOOL PrtInfo(char *filename, ostream &out)
{
  GINT       i, j, k, n, ndata;
  GINT       *Nx, *idims;
  GDOUBLE      *meta, *tags;
  GVector   *vdata;
  Point3D    *vert;
  GBinReader gbin;

  if ( !gbin.Open(filename) )
  {
    out << "PrtInfo: cannot open file named " << filename <<
            " Reader error: " << gbin.Error() << endl;
    return FALSE;
  }
  out << "File summary for '" << filename << "':" << endl << endl;;
  out << "File descriptor      : " << gbin.GetMetaDesc() << endl;
  out << "Endian swapped?      : " << gbin.EndianSwapped() << endl;
#if 0
  out << "Datatype size key    : GINT     = " << gbin.GetDatatypeSz(GBR_GINT )    << endl;
  out << "                       GSHORT   = " << gbin.GetDatatypeSz(GBR_GSHORT)   << endl;
  out << "                       GDOUBLE  = " << gbin.GetDatatypeSz(GBR_GDOUBLE)  << endl;
  out << "                       ELEM_SZ  = " << gbin.GetDatatypeSz(GBR_ELEM_SZ)  << endl;
  out << "                       GFPOS_SZ = " << gbin.GetDatatypeSz(GBR_GFPOS_SZ) << endl;
#endif
  out << "Number of datasets   : " << gbin.GetNumDataSets() << endl;
  meta = gbin.GetMeta();
  out << "Meta Data            : " << endl;
  for ( n=0; n<gbin.GetNumMeta(); n++ ) 
    out << "                     (" << n << "): " << meta[n] << endl;
  for ( n=0; n<gbin.GetNumDataSets(); n++ ) {
    tags  = gbin.GetTags(n);
    idims = gbin.GetDims(n);
    vert= gbin.GetVert(n);
    for ( i=0, ndata=1; i<gbin.GetRank(n); i++ ) ndata *= idims[i];
    vdata = new GVector (ndata);
    out << endl;
    out << ".......................................Dataset: " << n << ":" << endl << endl;
    out << "         Label         : " << gbin.GetLabel   (n) << endl;
    out << "         Rank          : " << gbin.GetRank    (n) << endl;
    out << "         Dims          : (" ;
    for ( i=0; i<gbin.GetRank(n)-1; i++ ) 
      out <<  idims[i] << ", ";  
    out << idims[gbin.GetRank(n)-1] << " )" << endl;
    out << "         Tags          :  " << endl; 
    for ( i=0; i<gbin.GetNumTags(n); i++ ) 
      out << "                       (" << i << "): " << tags[i] << endl;
    out << "         No. Verts     : " << gbin.GetNumVert (n) << endl;
    out << "         Elem_Type     : " << gbin.GetElemTypes(n) << endl;
    out << "         Elem_Vert     : ";
    for ( k=0; k< gbin.GetNumVert(n); k++ ) cout << vert[k] << " "; 
    out << endl;
    out << "         Coord dims    : (";
    for ( i=0; i<gbin.GetRank(n)-1; i++ ) out << gbin.GetCoordDims(n,i+1) << ",";  
    cout << gbin.GetCoordDims(n,gbin.GetRank(n)) << ")" << endl;
    if ( gbin.GetFieldData(n, vdata->Data(), ndata) ) {
      out << "         Data (Max,Min): (" << vdata->Max() << ", " << vdata->Min() << ")"<< endl;
    }
    else
      out << "PrtInfo: cannot retrieve field data" << endl;
  }
  gbin.Close();
  return TRUE;
} // end of method PrtInfo

//************************************************************************************
// METHOD     : CmdLineParse
// DESCRIPTION: Parses command line args.
// ARGUMENTS  :
// RETURNS    : TRUE on success; else FALSE
//************************************************************************************
GBOOL CmdLineParse(int argc, char *argv[])
{
  GINT    i, j;

  j = 1;
  while ( j<argc ) {
    if ( strcmp(argv[j],"-h")==0 || argc < 2  ) {
      cout << "Enter:" << endl;
      cout << "     " << argv[0] << " file1 file2 file3 ... " << endl;
      exit(0);
    }
    else {
      j++;
    }
  }
  return TRUE;
} // end of method CmdLineParse
