//************************************************************************************//
// Module       : gtypes.h
// Date         : 7/9/01 (DLR)
// Copyright    : 2001-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Provides global data types for GASpAR code
// Derived From : none.
// Modifications:
//************************************************************************************//
#if !defined(_AIX)
#include <stdint.h>
#endif
#include <limits.h>
#include <float.h>
#include <string>
#include "gcommdata_t.h"

#if 0
// Some system precompiler defs. Some are set here based on the others:
#define _LINUX
#define _AIX
#define _COMPILER_PG
#define _COMPILER_GCC
#define _INT32
#define _INT64
#define _GBYTESWAP
#endif

//--------------------------------------------------------------------------------
// Problem spatial dimension
//--------------------------------------------------------------------------------
#if defined(_INT32)
#define szCACHE             16
#elif defined(_INT64)
#define szCACHE             32
#else
#define szCACHE             16
#endif

#define szCACHEMAX          128
#define IS2D                
#define NPROCESSES_PER_NODE 4

//--------------------------------------------------------------------------------
// GASPAR Datatypes
//--------------------------------------------------------------------------------
// NOTE: if these are changed, then be sure to modify
//       src/comm/gcommdata_t.h for the comparable 
//       MPI datatypes.
#define GDOUBLE        double
#define GFLOAT         float
#define GQUAD          long double
#define GINT           int
#define GLONG          long
#define GSHORT         short
#define GUSHORT        unsigned short
#define GBYTE          unsigned char
#define GINT4BYTE      int
#define GUCHAR         unsigned char
#define GCHAR          char
#define ISUB           GINT 
#define GFPOS          long long
#define GIOS_MODE      int
#define GCHandle       long
#define GDWORD         long long
#define GWORD          int
#define GKEY           GDWORD
#define GNODEID        long long 
#define GCOMPID        GINT 
#define HDFID          hid_t
#define HDFERR         herr_t
#define HDFHSIZE       hsize_t
#define HDFHSSIZE      hssize_t
#define G_NUM_ELEM_TMP 2
#define PI             3.14159265358979            

// For GTBuffer<>, define distinct types. Set these
// if the indicated type is unique; if not, it is already 
// defined.
#define GBUFF_DEF_GQUAD
#define GBUFF_DEF_GSHORT 
#define GBUFF_DEF_GUSHORT 
#define GBUFF_DEF_GINT 
#define GBUFF_DEF_GLONG
#define GBUFF_DEF_BYTE
#define GBUFF_DEF_GDOUBLE
#define GBUFF_DEF_BDYTYPE
#define GBUFF_DEF_ELEMTYPE
#define GBUFF_DEF_GKEY
//#define GBUFF_DEF_GCHANDLE
//#define GBUFF_DEF_GWORD
//#define GBUFF_DEF_GDWORD
//#define GBUFF_DEF_GNODEID

#undef _GBYTESWAP
#if defined(_AIX)
#  define _GBYTESWAP
#endif

#if defined(_AIX)
typedef std::string string;
#endif

// GWORD and GDWORD defined for GlOp::Init
#if 0
#define GWORD_BITSIZE  (8*sizeof(GWORD))
#define ONE_MASK      0xFFFFFFFFFFFFFFFF
#define HI_MASK       0xFFFFFFFF00000000
#define LO_MASK       0x00000000FFFFFFFF
#endif

#if 0
#define GWORD          short
#define GDWORD         long 
#define GWORD_BITSIZE  (8*sizeof(GWORD))
#define ONE_MASK      0xFFFFFFFF
#define HI_MASK       0xFFFF0000
#define LO_MASK       0x0000FFFF
#endif

#if   defined(IS1D)
#define GDIM                1
#elif defined(IS2D)
#define GDIM                2
#elif defined(IS3D)
#define GDIM                3
#else
#error "Bad Dimensionality"
#endif

#if !defined(GBASIS_TYPE_DEF)
#define GBASIS_TYPE_DEF
enum GBASIS_TYPE{GBASIS_GLL=0,GBASIS_GL};
#endif
 
// Datatypes for communication:
#if !defined(G_DATATYPE_DEF)
#define  G_DATATYPE_DEF
enum G_DATATYPE {G_GFLOAT=0,G_GDOUBLE ,G_GQUAD  ,G_GINT  ,G_GSHORT ,G_GUSHORT ,
                 G_GLONG   ,G_BYTE    ,G_GUCHAR ,G_GWORD ,G_GDWORD ,G_GFPOS   ,
                 G_GKEY    ,G_GNODEID ,G_ELEMTYPE,G_BDYTYPE};
const GINT  G_TYPESZ[] = {sizeof  (GFLOAT),sizeof  (GDOUBLE),sizeof (GQUAD),sizeof (GINT ),sizeof(GSHORT ),
                          sizeof(GUSHORT ),sizeof   (GLONG ),sizeof (GBYTE),sizeof(GUCHAR),
                          sizeof   (GWORD),sizeof   (GDWORD),sizeof (GFPOS),sizeof  (GKEY), 
                          sizeof (GNODEID),sizeof    (GINT ),sizeof (GINT )};
#endif


// define element components:
#if !defined(GELEM_COMP_DEFS)
#define GELEM_COMP_DEFS
#define GELEM_VERTEX       0
#define GELEM_PARENT_EDGE  1
#define GELEM_CHILD_EDGE   2
#define GELEM_VVERTEX      3
#define GELEM_FACE         4
#endif

//enum GBOOL {FALSE=0,TRUE=1};
#if !defined(GBOOL)
#define GBOOL bool
#endif
#if !defined(TRUE)
#define TRUE  true
#endif
#if !defined(FALSE)
#define FALSE false
#endif

// limits, etc:
#define FBAD       -1.0e60
#if !defined(SEHUGE)
//#  define SEHUGE       DBL_MAX
#  define SEHUGE       1.0e60
#endif
#if !defined(IHUGE)
#  define IHUGE        INT_MAX
#endif
#if !defined(TINY)
//#  define TINY         DBL_MIN
#  define TINY         1.0e-15
#endif
#if !defined(SFPTINY)
//#  define SFPTINY    FLT_MIN
#  define SFPTINY    1.0e-8
#endif
#define TINYTINY   1.0e-40


//--------------------------------------------------------------------------------
// Miscellaneous defs
//--------------------------------------------------------------------------------
#define GFPOS_NULL        ((GFPOS)(-1))
#define GFPOS_NO_COORD     0
#define gios               GStream
#define NULL_HANDLE        -1
#define FILE_NAME_MAX      80
#define CMD_STR_MAX        80
#define DELIM_MAX          4
#define MAX_GDD_STRING     1024
#if defined(MPI_GENERIC_DEFAULT)
#define GMAX_ERROR_STRING MPI_MAX_ERROR_STRING
#else
#define GMAX_ERROR_STRING  1024
#endif
#define BITSPERBYTE        8
#define MAX_OPHANDLES      2
#define MAX_REFINE_LEVELS  6
#define HDF_PASS           0
#define MPI_PASS           0
#if !defined(WORDSIZE_BITS)
#if defined(_AIX)
#  define WORDSIZE_BITS WORD_BIT
#else
#  define WORDSIZE_BITS __WORDSIZE
#endif
#endif
#if !defined(WORDSIZE_BYTES)
#  define WORDSIZE_BYTES (WORDSIZE_BITS / BITSPERBYTE)
#endif


//--------------------------------------------------------------------------------
// Useful enum, structure defs
//--------------------------------------------------------------------------------
#if !defined(IO_TYPE_DEF)
#define IO_TYPE_DEF
enum IO_TYPE {INDEPENDENT_IO=1, COLLECTIVE_IO=2};
#endif

#if !defined(FILE_ACCESS_DEF)
#define FILE_ACCESS_DEF
enum FILE_ACCESS {READ_ONLY, READ_WRITE};
#endif

#if !defined(UTYPE_DEF)
#define UTYPE_DEF
union UTYPE {
GUSHORT iushort;
GSHORT  ishort;
GINT    iint;
GLONG   ilong;
GDOUBLE fdouble;
GQUAD   fldouble;
};
#endif


#if !defined(IPOINT2DTYPE_DEF)
#define IPOINT2DTYPE_DEF
struct IPoint2D {
GINT  i1;
GINT  i2;
};
#endif

#if !defined(IPOINT3DTYPE_DEF)
#define IPOINT3DTYPE_DEF
struct IPoint3D {
GINT  i1;
GINT  i2;
GINT  i3;
};
#endif

// CHandle: for calls to underlying transport layer
#if !defined(CHANDLE_DEF)
#define CHANDLE_DEF
class CHandle {
public :
GINT   nposts;
void   *mhandle;
CHandle() { nposts = 0; mhandle = NULL; }
~CHandle() { if ( mhandle!=NULL ) delete [] mhandle; }
#if 0
void operator=(CHandle &ch) { 
  GINT i;
  nposts=ch.nposts; 
  if ( mhandle!=NULL ) delete [] mhandle; mhandle = NULL;
  if ( ch.mhandle != NULL ) { 
    for ( i=0; i<nposts; i++ ) mhandle[i] = ch.mhandle[i];
  }
}  
friend ostream&  operator<<(ostream&os, CHandle &h) {
  os   << "nposts    =" << h.nposts         << endl;
       << "mhandle   =" <<(GBYTE*)h.mhandle << endl;
  return os;
}
#endif
};
#endif


#if !defined(FPOINT3DTYPE_DEF)
#define FPOINT3DTYPE_DEF
#define Point3D Point
#endif


#if !defined(STOPCONDTYPE_DEF)
#define STOPCONDTYPE_DEF 
enum STOPCONDTYPE {BY_TIME, BY_CYCLE};
#endif

#if !defined(OUTPUTTYPE_DEF)
#define OUTPUTTYPE_DEF
enum OUTPUTTYPE {OUT_BIN, OUT_SDS};
#endif

#if !defined(BDYTYPE_DEF)
#define  BDYTYPE_DEF
enum BDYTYPE {DIRICHLET=0, NEUMANN, PERIODIC, NOSLIP, NONE=-1};
#endif

#if !defined(ELEMTYPE_DEF)
#define  ELEMTYPE_DEF
enum ELEMTYPE {DEFORMED_QUAD, RECT_QUAD, TRIANGULAR, UNDEFINED=-1};
#endif

#if !defined(TIMEEVOLTYPE_DEF)
#define  TIMEEVOLTYPE_DEF
enum TIME_EVOLTYPE{TE_OIFS=0, TE_ABBDF, TE_EXBDF, TE_AMFE};
#endif


#if !defined(GPC_TYPES)
#define GPC_TYPES
enum GPC {GPC_BLOCKJAC_HELM=0, GPC_BLOCKJAC_LAP, GPC_POINTJAC_HELM, GPC_NONE};
#endif


#if !defined(SI_FORCE_TYPES)
#define SI_FORCE_TYPES
enum SI_FORCE_TYPE {SI_NONE=0, SI_EV};
#endif

#if !defined(G_OP_TYPES)
#define G_OP_TYPES
enum G_OP {G_OP_SUM=0, G_OP_PROD, G_OP_MAX, G_OP_MIN, G_OP_ASSIGN};
#endif

#if !defined(GDISTANCE_DEF)
#define GDISTANCE_DEF
#define PDISTANCE(p1,p2) sqrt( (p2[0]-p1[0])*(p2[0]-p1[0])   \
                              +(p2[1]-p1[1])*(p2[1]-p1[1])   \
                              +(p2[2]-p1[2])*(p2[2]-p1[2]) )
#endif
//--------------------------------------------------------------------------------
// Macro functions
//--------------------------------------------------------------------------------
#ifndef MIN
#define MIN(a,b)   (a<b?a:b)
#endif
#ifndef min
#define min(a,b)   (a<b?a:b)
#endif
#ifndef MAX
#define MAX(a,b)   (a>b?a:b)
#endif
#ifndef max
#define max(a,b)   (a>b?a:b)
#endif


//--------------------------------------------------------------------------------
// Define the HIWORD, LOWORD and SET_HW, SET_LW, SET_DW macros for
// manipulating GDWORD quantities. The following algorithms were 
// chosen in order to handle GDWORDs, such as long long, which are
// non-standard, and for which the bit shift operators do not always work
// properly. Component id macros are defined here also; these could use the
// bit-shift operators, but we define them to remain consistent with the 
// HI(LO)GWORD macros.
//--------------------------------------------------------------------------------
#if defined(_GBYTESWAP)
#  define HIWORD(dw)  ( (*((GWORD*)dw  )) )
#  define LOWORD(dw)  ( (*((GWORD*)dw+1)) )
#  define SET_HW(xdw,xhi) ( memcpy((GWORD*)xdw  ,xhi,sizeof(GWORD)) )
#  define SET_LW(xdw,xlo) ( memcpy((GWORD*)xdw+1,xlo,sizeof(GWORD)) )
#  define SET_DW(xdw,xhi,xlo) memcpy((GWORD*)xdw+1,xlo,sizeof(GWORD)); memcpy((GWORD*)xdw  ,xhi,sizeof(GWORD))

// Defined component id macros:
#  define COMPTYP(dw) ( (*((GBYTE*)dw+2)) )
#  define COMPNUM(dw) ( (*((GBYTE*)dw+1)) )
#  define COMPANC(dw) ( (*((GBYTE*)dw  )) )
#  define SET_COMP(xdw,xtyp,xnum,xanc)  *xdw=0; memcpy((GBYTE*)xdw+2,xtyp,sizeof(GBYTE)); \
                                                memcpy((GBYTE*)xdw+1,xnum,sizeof(GBYTE)); \
                                                memcpy((GBYTE*)xdw  ,xanc,sizeof(GBYTE)) 
#else
#  define HIWORD(dw)  ( (*((GWORD*)dw+1)) )
#  define LOWORD(dw)  ( (*((GWORD*)dw  )) )
#  define SET_HW(xdw,xhi) ( memcpy((GWORD*)xdw+1,xhi,sizeof(GWORD)) )
#  define SET_LW(xdw,xlo) ( memcpy((GWORD*)xdw  ,xlo,sizeof(GWORD)) )
#  define SET_DW(xdw,xhi,xlo) memcpy((GWORD*)xdw  ,xlo,sizeof(GWORD)); memcpy((GWORD*)xdw+1,xhi,sizeof(GWORD))
 
// Defined component id macros:
#  define COMPTYP(dw) ( (*((GBYTE*)dw  )) )
#  define COMPNUM(dw) ( (*((GBYTE*)dw+1)) )
#  define COMPANC(dw) ( (*((GBYTE*)dw+2)) )
#  define SET_COMP(xdw,xtyp,xnum,xanc)  *xdw=0; memcpy((GBYTE*)xdw  ,xtyp,sizeof(GBYTE));\
                                                memcpy((GBYTE*)xdw+1,xnum,sizeof(GBYTE));\
                                                memcpy((GBYTE*)xdw+2,xanc,sizeof(GBYTE))  
#endif


#if 0
//--------------------------------------------------------------------------------
// The bit--shift operators don't work for non-standard sizes, such as long long,
// so we don't use them here:
//--------------------------------------------------------------------------------
#if !defined(HIWORD)
# if defined(_GBYTESWAP)
#  define HIWORD(x) ( (GWORD)( ( (GDWORD)(x) ) & LO_MASK ) )
# else
#  define HIWORD(x) ( (GWORD)( ( (GDWORD)(x) >> GWORD_BITSIZE) & LO_MASK ) )
# endif
#endif

#if !defined(LOWORD)
#if defined(_GBYTESWAP)
#  define LOWORD(x) ( (GWORD)( ( (GDWORD)(x) >> GWORD_BITSIZE) & LO_MASK ) )
# else
#  define LOWORD(x) ( (GWORD)( ( (GDWORD)(x) ) & LO_MASK ) )
# endif
#endif

#if !defined(SET_DW)
#if defined(_GBYTESWAP)
#  define SET_DW(xhi,xlo) (  ( ( (GDWORD)(xlo) << GWORD_BITSIZE ) & ONE_MASK ) \
                          |    ( (GDWORD)(xhi)                 )            )
# else
#  define SET_DW(xhi,xlo) ( ( ( (GDWORD)(xhi) << GWORD_BITSIZE ) & HI_MASK  ) \
                          | (   (GDWORD)(xlo)                   & LO_MASK  ) ) 
# endif
#endif
#endif



