//************************************************************************************//
// Module       : gasparFile.hpp
// Date         : 6/11/02 (RMP)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Base class encapsulating the methods and data associated with
//                a Gaspar file.
// Derived From : none.
// Modifications:
//************************************************************************************//

#if !defined(GASPARFILE_HPP)
#define GASPARFILE_HPP

#include "mpi.h"
#include "gtypes.h"
#include "hdf5.h"
#include <iostream.h>

class GasparFile{

public:

  //public methods:
  virtual ~GasparFile(){}
  virtual GBOOL close() = 0;
  virtual GBOOL open(FILE_ACCESS accessIn, ISUB fileNestDepth = FILE_DEPTH_DEFAULT) = 0;
  virtual GBOOL openCreate(GBOOL overWriteIn, ISUB fileNestDepth = FILE_DEPTH_DEFAULT) = 0;
  virtual GBOOL openGroup(const char* groupName) = 0;
  virtual GBOOL createGroup(const char* groupName, GUSHORT  hint = GROUP_HINT) = 0;
  virtual GBOOL closeGroup() = 0;
  virtual GBOOL up() = 0;
  virtual GBOOL top() = 0;
  virtual GBOOL writeMeta(const char* metaName, HDFID location, GDOUBLE meta) = 0;
  virtual GBOOL writeMeta(const char* metaName, HDFID location, GDOUBLE *meta, GSHORT  len) = 0;
  virtual GBOOL writeMeta(const char* metaName, HDFID location, ISUB meta) = 0;
  virtual GBOOL readMeta(const char* metaName, HDFID location, GDOUBLE& meta) = 0;
  virtual GBOOL readMeta(const char* metaName, HDFID location, ISUB& meta) = 0;
  virtual GBOOL writeVector(const char* dataName, const GDOUBLE* data, ISUB dataSize) = 0;
  virtual GBOOL writeVector(const char* dataName, const ISUB* data, ISUB dataSize) = 0;
  virtual GBOOL readVector(const char* dataName, GDOUBLE*& data, ISUB& dataSize) = 0;
  virtual GBOOL readVector(const char* dataName, ISUB*& data, ISUB& dataSize) = 0;
  virtual GBOOL writeMatrix(const char* dataName, GDOUBLE* data, ISUB n1, ISUB n2) = 0;
  virtual GBOOL readMatrix(const char* dataName, GDOUBLE*& data, ISUB& n1, ISUB& n2) = 0;
  GBOOL isOpen() const { return openStatus; }
  const char* getFileName() const { return fileName; }
  MPI_Comm getHDFComm() const { return hdfComm; }
  MPI_Comm getMPIComm() const { return mpiComm; }
  FILE_ACCESS getFileAccess(){ return fileAccess; }
  

protected:

  //protected methods:
  GBOOL setFileName(const char* fileNameIn);
  void setOpenStatus(GBOOL openStatusIn){ openStatus = openStatusIn; }
  void setFileAccess(const FILE_ACCESS accessIn){ fileAccess = accessIn; }
  GBOOL setComms(MPI_Comm parentComm, ISUB** procLists, ISUB nLists, ISUB* listSizes);
  GBOOL setComms(MPI_Comm commIn);

  //protected data:
  static const ISUB FILE_DEPTH_DEFAULT;
  static const char* VSIZE_META_NAME;
  static const char* MDIM_1_NAME;
  static const char* MDIM_2_NAME;
  enum DATA_OPERATION { CREATE, XFER }; 
  static const GUSHORT  GROUP_HINT;          //Default total size hint (in bytes) for all objects to be
                                            //...be included in a particular group

private:

  //private data:
  const char* fileName;
  GBOOL openStatus;
  FILE_ACCESS fileAccess;
  MPI_Comm mpiComm, hdfComm;
  static const char* THIS;

};

#endif
