//************************************************************************************//
// Module       : gasparFileReader.hpp
// Date         : 7/15/02 (RMP)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                Gaspar file input.
// Derived From : GasparFileIO.
// Modifications:
//************************************************************************************//

#if !defined(GASPARFILEREADER_HPP)
#define GASPARFILEREADER_HPP

#include "gasparFileIO.hpp"
#include "gtvector.hpp"
#include "gtmatrix.hpp"
#include "gtypes.h"
#include <iostream.h>
#include <string.h>

class GasparFileReader : public GasparFileIO{

public:
  
  //public methods:
  GasparFileReader();
  ~GasparFileReader();
  GBOOL read(SEVector*& vector, const char* vectorName);
  GBOOL read(SEMatrix* matrix, const char* matrixName);

private:

  //private data:
  char* errorMsg;
  static const char* THIS;        //Class name used in error messages
};
#endif
