//************************************************************************************//
// Module       : gasparFileWriter.hpp
// Date         : 7/15/02 (RMP)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                Gaspar file ouput.
// Derived From : GasparFileIO.
// Modifications:
//************************************************************************************//

#if !defined(GASPARFILEWRITER_HPP)
#define GASPARFILEWRITER_HPP

#include "gasparFileIO.hpp"
#include "gtvector.hpp"
#include "gtmatrix.hpp"
#include "gtypes.h"
#include <iostream.h>

class GasparFileWriter : public GasparFileIO{

public:
  
  //public methods:
  GasparFileWriter();
  ~GasparFileWriter();
  GBOOL createFile(GasparFile* inFile, GBOOL overWrite);
  GBOOL createHDF(const char* fileNameIn, GBOOL overWrite, IO_TYPE fType = COLLECTIVE_IO, IO_TYPE dType = INDEPENDENT_IO, 
		   MPI_Comm commIn = MPI_COMM_WORLD);
  GBOOL write(const SEVector& vector, const char* vectorName);
  GBOOL write(const SEMatrix& matrix, const char* matrixName);


private:

  //private data:
  char* errorMsg;
  GBOOL pass;
  static const char* THIS;                   //Class name used in error reporting
};
#endif
