//************************************************************************************//
// Module       : gbin_stream.hpp
// Date         : 10/17/02 (DLR)
// Copyright    : 2002, 2003 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                the object that associates a stream to a GASpAR binary data file
// Derived From : GStream.
// Modifications:
//************************************************************************************//
#if !defined(GBIN_STREAM_HPP)
#define GBIN_STREAM_HPP 
#include "gtypes.h"
#include "gdd_file.h"
#include "gtbuffer.hpp"
#include <iostream.h>
#include <fstream.h>
#include "gcomm.hpp"
#include "gstream.hpp"
#if defined(MPI_IO_DEFAULT)
#include "mpi.h"
#endif

#define MAX_DATASETS   50000

extern char *identifier_ ;

class GBinStream: public GStream
{
public:
                          GBinStream(GBOOL isCollective=FALSE, GBOOL isIndependent=TRUE, GSHORT  ioTaskID=0);
//                        GBinStream(const GBinStream &);
                         ~GBinStream();
         GBOOL            Open(const char *, GIOS_MODE omode, GBOOL bDelete=FALSE);
         void             Close();
         GINT             GetNumDataSets();
         GFPOS            pOffsetBlk();                     // file position of DS offset block
         GFPOS            pDSNum();                         // file position of DS number
         GINT             GetDSNum();                       // get number of datasets in file
         GBOOL            Check();
         GBOOL            EndianSwapped();
         void             ResetSizes(GBOOL bReset);         // reset datatype sizes ?


protected:
//    methods:

//    data:

         GBOOL            bEndianSwapped_;
         GBOOL            bResetSizes_;
         GINT             gndatasets_;
         GINT             ndtypes_;
         GFPOS            *dsOffset_;
//       char             *serrmsg;

         GINT4BYTE         i4sz;
         GINT4BYTE         isz;
         GINT4BYTE         sisz;
         GINT4BYTE         fsz;
         GINT4BYTE         gfsz;
         GINT4BYTE         esz;
         GINT4BYTE         *szkey_;

private:

};

#endif
