//************************************************************************************//
// Module       : gbin_writer.hpp
// Date         : 10/17/02 (DLR)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                the object that writes a GASpAR binary data file
// Derived From : GBinStream.
// Modifications:
//************************************************************************************//
#if !defined(GBIN_WRITER_HPP)
#define GBIN_WRITER_HPP 
#include "gtypes.h"
#include "gdd_file.h"
#include "gbin_stream.hpp"
#include "point.hpp"
#include "gtbuffer.hpp"
#include <iostream.h>
#include <fstream.h>



class GBinWriter: public GBinStream
{
public:
                          GBinWriter(GBOOL isCollective=FALSE, GBOOL isIndependent=TRUE, GSHORT  ioTaskID=0);
//                        GBinWriter(const GBinWriter &);
                         ~GBinWriter();
         GBOOL            Open(const char *);
         GBOOL            Open(const char *, GIOS_MODE iomode, GBOOL bDelete=FALSE);
         void             Close();
         GBOOL            SetMeta(GINT  nmeta, GDOUBLE *meta_data, const char *descriptor);
         GBOOL            SetDims(GINT  rank, GINT  *dims);
         GBOOL            SetVertices(const GINT  num, Point *vertices, ELEMTYPE etype);
         GBOOL            SetCoord(GINT  idir, GINT  dim, GDOUBLE *coord, const char *descriptor);
         GBOOL            WriteData(GINT  rank, GINT  *dims, GDOUBLE *data  , GINT  ntags, GDOUBLE *ftags, 
                                    const char *descriptor, GFPOS *datablk);
         GFPOS            InitData(GINT  rank, GINT  *dims, GDOUBLE c, GINT  ntags, GDOUBLE *ftags, const char *descriptor);
         GBOOL            RewriteData(GFPOS data_start, GINT  n, GINT  *inewdata, GDOUBLE *newdata);
         GBOOL            UpdateMeta(GINT  nds, GINT  ids, GFPOS newoffset);
         GBOOL            UpdateMeta();
         GINT             GetTotalWritten();
         void             EndLoop(GINT);
#if defined(DO_GBIN_TIMING)
         void              ResetTime();
         GDOUBLE             GetTime();
private:
         GDOUBLE             time_result_;
#endif
private:
//    methods:
         void             DeleteDynamic();
         GFPOS            WriteMeta();
         GFPOS            WriteCoordBlock();
         GFPOS            PutData(GDOUBLE *data,  GINT  ntags, GDOUBLE *ftags, const char *descriptor, 
                                  GFPOS coord_offset, GFPOS &datablk_off);
         GFPOS            MetaLen();
         GFPOS            CoordLen();
         GFPOS            DataLen();
   

//    data:
         GINT           rank_;
         GINT           *idims_;
         GINT           nVert_;
         GINT           nVertMax_;
         GINT           nTags_;     
         GINT           NN;
         GINT           nTotalWritten_;
         GINT           ndsdelta_;
         GINT           gnds_;
         GINT4BYTE      nMeta_;
         GBOOL          bRankSet_;
         GBOOL          bIsNew_;
         GBOOL          bNewCoord_;
         ELEMTYPE       etype_;
         GFPOS          coordOffset_;
         GFPOS          datasegOffset_;
         GDOUBLE        *fMeta_;
         GDOUBLE        *Vert_;     
         GDOUBLE        **xCoord_;     
         GINT           *nCoord_;     
         char           *sMeta_;   
         char           **sCoord_;   
         char           *sData_;   
         GUCharBuffer    dput_;
         GUCharBuffer    hMeta_;

};

#endif
