//************************************************************************************//
// Module       : param_reader.hpp
// Date         : 12/5/02 (DLR)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                the ParamReader object.
// Derived From : GStream.
// Modifications:
//************************************************************************************//
#if !defined(PARAM_READER_HPP)
#define PARAM_READER_HPP 
#include "gtypes.h"
#include "gdd_file.h"
#include "gstream.hpp"
#include "gtlist.hpp"
#include <iostream.h>
#include <fstream.h>
#include <stdarg.h>
//#include <varargs.h>

class ParamReader: public GStream
{
public:
                          ParamReader(GBOOL isCollective, GBOOL isIndependent=TRUE, GSHORT  ioTaskID=0);
//                        ParamReader(const ParamReader &);
                         ~ParamReader();
         void             SetParams(char *format, ...); 
         GINT             GetParams(char *filename, char *blk_name,  ...);
         void             SetBuffSize(GINT  n);

private:
//    methods:
         GBOOL            LocateBlock(const char *name);
         GSHORT           getdata_t(char *sdata, G_DATATYPE dtype, const char *datadelim, const char *termdelim,
                                    void *data, const GSHORT  ndata);
         GSHORT           getline(char *sbuff, const GINT  num, const char *delim);
         GBOOL            getblock(char *sbuff, GINT  num, char *delim0, char *delim1);
         GBOOL            ignore(const char *str);
         GBOOL            skipblock(const char *delim0, const char *delim1);
         char            *rmwhite(char *str);
         void             Reset();


//    data:
         GINT            buffsize_;
         GINT            maxParams_;
         GStringList     sParamDesc_;
         GStringList     sFormat_;
//       char            *serrmsg_;
         char            *buff_;
         char            delimblk_[2][DELIM_MAX+1];
         char            delimeol_   [DELIM_MAX+1];
         char            delimlist_  [DELIM_MAX+1];
         char            comment_ [3];
         ifstream        *os_;

 
};

#endif
