%
% Test BurgersH.m:
%
x=(-511.5:511.5)'/512;
[u0 p0]=Burgers0;
[u p]=BurgersH;
figure(1)
clf
subplot(311)
h=plot(x,p./p0-1);
title({'Comparing Hermite integration ({\fontname{Courier}BurgersH.m}) vs Fourier series ({\fontname{Courier}Burgers0.m)}'
       'at viscosity {\nu}=10^{-2}'})
legend(h,transpose(reshape(sprintf('{\\pi\\itt}=%d',1:3),11,3)),4)
ylabel('relative \phi({\itt},{\itx}) error')
subplot(312)
plot(x,u./u0-1)
xlabel('\itx')
ylabel('relative {\itu}({\itt},{\itx})=-2\nu\partial_{\itx}ln\phi error')
subplot(313)
nn=50;
for n=1:nn
   [u p d(n)]=BurgersH(1e-2/pi,1.6037/pi,0,n);
end
semilogy(1:nn,abs(d/152.00516+1),'.')
axis tight;a=axis;axis([1 nn a(3) 1])
grid on
set(gca,'YTick',10.^(-7:2:0))
title(['Convergence of minimum \partial_{\itx}{\itu} to Basdevant et al. (1986)' ...
       ' at viscosity {\nu}=10^{-2}/\pi, time \pi{\itt}=1.6037'])
xlabel('Hermite degree {\itN}')
ylabel('|\partial_{\itx}{\itu}({\itt},0)/152.00516+1|')
orient tall
print -depsc BurgersHt.eps
%
% Test time & viscosity dependence:
%
figure(2)
clf
c='bgrcmk';
nu=[1:5 10]*1e-2/pi;
nnu=length(nu);
nt=128;
t=(0:nt-1)/nt*3/pi;
d=zeros(nnu,nt);
for m=1:nnu
   [u p d(m,:)]=BurgersH(nu(m),t,0);
end
h=plot(pi*t,d)
axis tight
grid on
legend(h,reshape(sprintf('\\pi\\nu=%4.2f',nu*pi),11,nnu)',3)
set(gca,'XTick',0:.25:3,'YTick',-150:10:0)
title('Analytic solution of Burgers shock, using Hermite integration of degree 50')
xlabel('\pi\itt')
ylabel('\partial_{\itx}{\itu}({\itt},0)')
orient tall
orient landscape
print -depsc Burgshoc.eps
%
x=(-511.5:511.5)'/512;
u00=0;
figure(3)
clf
for t=0:.1:1
   [u p]=BurgersH(1e-2/pi,t,x,[],u00);
   subplot(211)
   line(x,u)
   subplot(212)
   U=fft(u);
   if t==0,loglog(1:512,abs(U(2:513)),'.-')
   else,line(1:512,abs(U(2:513)),'Marker','.'),end
   pause
end
%
[x y]=meshgrid((-63.5:63.5)/64);
x=cat(3,x,y);clear y
wavevec=[1 2];
figure(4)
clf
k=.5;				% fine-flow factor
for t=0:.1:2
   s=t/(wavevec*wavevec');
   u=BurgersH(1e-2,s,x,[],.5,k,wavevec);
   mesh(x(:,:,1),x(:,:,2),wavevec(1)*u(:,:,1))
   if t==0
      a=axis;
   else
      axis(a)
   end
   s=sprintf('time %8.2e',s);
   title(s)
   disp([s '.  Hit any key to continue:'])
   pause
end
