function y=Hermite(n,x,g);
%
% y=Hermite(n,x);
% y=Hermite(n,x,1);
%
% Given vector x(1:m) return Hermite polynomials
% of degree j=0:n in row j+1 of y(1:n+1,1:m).
% The 1 argument requests the polynomials normalized
% by sqrt(2^j*factorial(j)*sqrt(pi)).
%
if n<0
   error('Hermite needs n>=0')
end
x=x(:)';			% ensure row shape
m=length(x);			% no. x points
y=zeros(n+1,m);			% allocate y
pim4=pi^-.25;			% 1/pi^(1/4)
y(1,:)=pim4;			% H~_0 = 1/pi^(1/4)
if n>0
   x=sqrt(2)*x;			% x only appears *sqrt(2)
   y(2,:)=x*pim4;		% H~_1 = sqrt(2)*x/pi^(1/4)
   if n>1
      for j=1:n-1		% loop over degrees
         y(j+2,:)=(x.*y(j+1,:)-sqrt(j)*y(j,:))/sqrt(1+j);
      end
   end
end
if nargin<3			% "standard" normalization
   j=0:n;
   f=[1 cumprod(sqrt(1:n))];	% sqrt(factorial(j))
   y=diag(f.*sqrt(2.^j)/pim4)*y;
end
