function h=Kovastre(filenm,ns,ifig,fs)
%
% h=Kovastre(filenm,ns,ifig,fs)
%
% Return handles h to ns (default 15) streamlines per element,
% plotted from data in file filenm (default 'kf4_0.002001'),
% in figure window ifig (default 1).
% Use fontsize fs (default 8) for labels.
% Print figure to filenm.eps.
%
if nargin<1
   filenm='kf4_0.002001';				% filename
end
[fileinfo elems u]=gbin_input(filenm);			% Kovasznay flow
%h = streelem(elems,u,ifig);				% default plot
if nargin<2
   ns = 15;						% no. streamlines
end
o = ones(1,ns);
if elems.n~=8
   error(sprintf('fournier has to write elems.n==%d case',elems.n))
end
[sx sy]=deal(zeros(ns,1,8));				% allocate ns*8 streamlines
if nargin<3
   ifig=1;
end
if nargin<4
   fs=8;
end
for i=1:2:7						% loop over 4 west elems.
   sx(:,1,i) = elems.x{i}(o,1,1);			% assign start x's
   h = linspace(elems.x{i}(1,1,2),elems.x{i}(1,end,2),ns+1);
   sy(:,1,i) = .5*(h(1:ns)+h(2:ns+1));			% assign start y's
end
[h fx fy xt yt] = streelem(elems,u,2,1:2:7,sx,sy);	% controled starts
for i=2:2:8						% loop over 4 east elems.
   sx(:,1,i) = elems.x{i}(o,1,1);			% west finishes => east starts
   for j=1:ns
      if abs(fx{j,1,i-1}(end,1)-sx(j,1,i-1))>.25	% test west streamline
         sy(j,1,i) = interp1(fx{j,1,i-1},fy{j,1,i-1},sx(j,1,i),'spline');
      else
         sy(j,1,i) = Inf;				% skip this streamline
      end
   end
end
[h0 fx fy xt yt] = streelem(elems,u,2,2:2:8,sx,sy,xt,yt);
[h{2:2:8}]=deal(h0{2:2:8});
set(gca,'XTickLabel',reshape(sprintf('%5.2f',xt)',5,length(xt))')
set(gca,'YTickLabel',reshape(sprintf('%5.2f',yt)',5,length(yt))')
orient tall
set(gca,'FontSize',fs)
eval(['print -deps ' filenm '.eps'])
