function w=biopelem(u,v,op,labu,labv,labw)
%
% w=biopelem(u,v,op,'labu','labv','labw');
%
% Assign to w field 'labw' (default 'labuoplabv') a binary operation on
% the u & v fields 'labu' and 'labv'.  The op can be a string
% 'plus', 'minus', 'times', 'rdivide' etc. (do "help ops" for examples)
% or more generally an expression like 'x/y-1' (do "help inline" for
% examples).  In the latter case 'labw' must be an acceptible field name.
%
nelem=length(eval(['u.' labu]));	% no. elements
if ~exist(op,'builtin')		% then op contains an expression:
   op=inline(op);
elseif nargin<6
   labw=[labu op labv];
end
for k=1:nelem
   x=eval(['u.' labu '{k}']);
   y=eval(['v.' labv '{k}']);
   z=feval(op,x,y);
   eval(['w.' labw '{k}=z;'])
%  eval(['w.' labw '{k}=' op '(u.' labu '{k},v.' labv '{k});'])
   eval(['w.' labw 'ic(k)=u.' labu 'ic(k);'])
end
