function [z1,z2,ke]=dirNWave(x,y1,y2,c,t)
%
% function u=dirNWave(x,y,c,t);
% function u=dirNWave(elems,V,c,t);
%
% u = NWave solution with Dirichlet bcs:
%
% u(t,x,y) = x_/t * 1 / [1 + sqrt(t/t0) * exp(x_^2/4 nu t) / ( exp(R_0) - 1 )]
%
%
% If (x,y) are passed they're assumed to have uniform meshgrid-type shapes.
% If (elems,V) are passed they correspond to typical elems structure and u.V1 field,
% and u has fields u.Va, u.Vaic, u.Verr=u.Va-V and u.Verric.
%
% c(1) in [0,1] is the x-location of the peak (default .5),
% c(2) in [0,1] is the y-location of the peak (default .5),
% c(3) is the initial profile time, t0>0 (default 0.1).
% c(4) is the diffusivity nu (default 1e-2) if t>0.
% c(5) is the Reynolds number, R0 (default 100).
%
% If t>t0 then return solution from t=t0 i.c. of
%
% u  = (nu div grad - u.grad)u
%
% Calling example:
%   [u1,u2]=perNWave(elem,u.V1,u.V2,[.5 .5 1 nu 100],t);

% 
eps = 1e-18;
if nargin<4|isempty(c)
   c=[.5 .5 1 1e-2 100];
end
if nargin<5
   t=c(3);				% initial condition
end
%c([1 3])=k([1 3])+eval(expr);
if isstruct(x)			% x is the structure elems
   flag=1;
   nelem=x.n;			% no. elements
   x=x.x;
else				% x & y are meshgrid-style
   flag=0;
   nelem=1;			% one element
   x={cat(3,x,y1)};		% imitate element structure
end
t0     = c(3)
R0     = c(5)
nufact = 1.0/( 4*c(4)*t );
rfact  = 1.0 / ( exp(R0) - 1);
tfact  = sqrt(t/t0);
for i=1:nelem			% loop over number elements
   p{1}=x{i}(:,:,1)-c(1);	% shift x by x0
   p{2}=x{i}(:,:,2)-c(2);	% shift y by y0 
   zer=zeros(size(p{1}));		% assume correct x size
   one =ones(size(p{1}));		% assume correct x size
   z1=zer;
   z2=zer;
   dz1=one;
   dz2=one;
   xpp = p{1};
   ypp = p{2};
   argp   = (xpp.^2+ypp.^2) .* nufact;    
   gfactp = 1.0./( t .* ( 1.0 + ( (tfact*rfact) .* exp(argp) ) ) );  
   z1    = gfactp.*xpp;
   z2    = gfactp.*ypp;

%  disp(sprintf('Element %d max shift: (%d,%d)',i-1,nit))
   z1(find(isnan(z1(:))))=0;		% eliminate NaN values
   z2(find(isnan(z2(:))))=0;		% eliminate NaN values
   if flag
      u1.Va{i}=z1(:,:,1);
      u1.Vaic(i)=i;
      u1.Verr{i}=u1.Va{i}-y1{i};		% error field
      u1.Verric(i)=i;
      u2.Va{i}=z2(:,:,1);
      u2.Vaic(i)=i;
      u2.Verr{i}=u2.Va{i}-y2{i};		% error field
      u2.Verric(i)=i;
      ke.Va{i}=z2(:,:,1)^2 + z1(:,:,1)^2;
      ke.Vaic(i)=i;
      ke.Verr{i}=ke.Va{i}-(y1{i}^2+y2{i}^2);		% error field
      ke.Verric(i)=i;
   end
end
if flag
   z1=u1;
   z2=u2;
end
