%
% Linear advection-diffusion analysis
%
owd=pwd;			% old (current) working directory
cd ~/sem/gaspar2d/test/
%cd data/results/liadvdif/1wave
if ~exist('u','var')
   d=dir('galump0a.*')
   lt=length(d)			% length of time series
   for n=1:lt			% loop over time:
      d(n).name
      [fileinfo(n) elems(n) u(n)]=gbin_input(d(n).name);
   end
end
nu=fileinfo(1).fmeta(23)	% diffusivity
for n=1:lt
   dt(n)=fileinfo(n).fmeta(10);
   tna(n)=fileinfo(n).fmeta(11);
end
for n=1:lt			% loop over time:
   ut(n)=onewave(elems(n),u(n).V1,[0 2*pi 0 0 nu],t(n),'[t t]');
   uenorm(n,1:2)=statelem(elems(n),ut(n),'Verr');
   utnorm(n,1:2)=statelem(elems(n),ut(n),'Va');
   uenorm(n,:)=uenorm(n,:)./utnorm(n,:);
end
figure(1)
semilogy(t,uenorm),pause
b=0;
for n=1:lt			% loop over time:
   h{n} = meshelem(elems(n),u(n),2,'V1');
   ht{n} = meshelem(elems(n),ut(n),3,'Va');
   he{n} = meshelem(elems(n),ut(n),4,'Verr');
   b=overWrite(b,sprintf('time=%d',t(n))),pause(30/lt)
end
eval(['cd ' owd])
