function gbin2mat(filepat)
%
% h=gbin2mat(filepat);
%
% Given filepat, a string with a file specification
% pattern (including path and * wildcards) like 'abc*xyz',
% convert GBin to MAT binary format for every
% filename (labeled j) that matches filepat, creating
% files like abc*xyz.mat.
%
d=dir(filepat);			% get output filenames
lt=length(d);			% length of time list
warning('gbin2mat:nread',sprintf('read %d files',lt))
l=max(strfind(filepat,'/'));	% isolate directory path
for j=1:lt			% loop over files
   z=[filepat(1:l) d(j).name];
   [fileinfo elems u]=gbin_input(z);
   eval(['save ' z '.mat fileinfo elems u'])
end
