function [rank,idims,slabel,tags,ntags,data,x1,x2,vert,nvert,stat] = ...
   gbin_dsread(filename,ioffset,iswap)
%
% ROUTINE      : gbin_dsread (fournier)
% DESCRIPTION  : Gets GBIN-file dataset data/info
% DATE         : 2003/10/14
%
% [rank idims slabel tags ntags data x1 x2 vert nvert stat] = ...
%   gbin_dsread(filename,ioffset,iswap);
%
[tags slabel data]=deal([]);
if iswap==1
  lun = fopen(filename,'r','ieee-be');		% logical unit number
else
  lun = fopen(filename);			% logical unit number
end
if lun==-1
   error(['File ' filename ' cannot be opened for reading'])
end
status = fseek(lun,ioffset,'bof');
if status
   error(sprintf('fseek(ioffset=%d,%d,''bof'') returns status=%d, ferror=%s', ...
      lun,ioffset,status,ferror(lun)))
end
icoffset = fread(lun,1,'int64');
ntags = fread(lun,1,'int32');
if ntags>0
   tags = fread(lun,ntags,'float64');
end
ilen = fread(lun,1,'int32');
if ilen>0
   slabel = char(transpose(fread(lun,ilen,'uchar')));
end
ndata = fread(lun,1,'int32');
if ndata>0
   data = fread(lun,ndata,'float64');
end
if ( icoffset > 0 )
status = fseek(lun,icoffset,'bof');
if status
   error(sprintf('fseek(icoffset=%d,%d,''bof'') returns status=%d, ferror=%s', ...
      lun,ioffset,status,ferror(lun)))
end
rank = fread(lun,1,'int32');
idims = transpose(fread(lun,rank,'uint32'));		% size should be row vector
if ndata==prod(idims)
   data = reshape(data,idims);
end
etype = fread(lun,1,'int32');
nvert = fread(lun,1,'int32');
vert = cell([nvert 1]);
vert = struct('x1',vert,'x2',vert,'x3',vert);
vvert = fread(lun,rank*2^rank,'float64');
nc = fread(lun,1,'int32');
for i=1:nvert
   j = (i-1)*rank+1;
   if rank==1
      vert(i).x1 = vvert(1);
      vert(i).x2 = vvert(2);
   elseif rank==2
      vert(i).x1 = vvert(j);
      vert(i).x2 = vvert(j+1);
   elseif rank==3                                                                        
      vert(i).x1 = vvert(j);
      vert(i).x2 = vvert(j+1);
      vert(i).x3 = vvert(j+2);
   end
end
if nc<1
   error(sprintf('cannot have nc=%d',nc))
elseif nc>=1
   nx1 = fread(lun,1,'int32');
   if nx1>0
      x1 = reshape(fread(lun,nx1,'float64'),idims);
   end
end
if nc>=2
   nx2 = fread(lun,1,'int32');
   if nx2>0
      x2 = reshape(fread(lun,nx2,'float64'),idims);
   end
end
if nc==3                                                                                 
   error('fournier has to write nc==3 handling')
   nx3 = fread(lun,1,'int32');
   if nx3>0
      x3 = reshape(fread(lun,nx3,'float64'),idims);
   end
end
else
  x1 = [];
  x2 = [];
  nvert = 0;
  vert = {};
end
stat = 1;
fclose(lun);
