function w=hd3Dinpu(f,l,m,n,machineformat,nb)
%
% par=hd3Dinpu('p.txt')
% time=hd3Dinpu('f',par)
% w=hd3Dinpu('f')
% w=hd3Dinpu('f',l,m,n,'machineformat',nb);
%
% Either:
% 1 input parameters structure par.dt, par.step etc. from ascii
%   file p.txt, or
% 2 compute time of binary file f from previous par, or
% 3 if ~strcmp(f(end-3:end),'.txt') input variable w(1:l,1:m,1:n)
%   from ForTran unformatted binary file f.
%   The defaults for 2D data:
%
%   l			sqrt((int from f's 1st 32 bits)/nb)
%   m			l
%   n			1
%   'machineformat'	'ieee-le' (use 'ieee-be' for big endian)
%   nb			4 (number of bytes per float)
%
if nargin<6|isempty(nb)
   nb=4;
end
if nargin<5|isempty(machineformat)
   machineformat='ieee-le';
end
[fid,message]=fopen(f,'r',machineformat);	% file identifier
if length(message)
   error('hd3Dinpu(fopen): %s',message)
end
lmn=fread(fid,1,'int32');
if nargin<2|isempty(l)
   l=sqrt(lmn/nb);
end
if strcmp(f(end-3:end),'.txt')
   F=textread(f,'%s','delimiter','\n');
   l=length(F);		% length of file f
   for k=1:l-1		% loop until last line but one:
      n=strfind(F{k},'%');
      c=['w.' F{k}(n+2:end) '=' F{k}(1:n-1) ';'];
      eval(c)		% assign pre-% number to post-% label
   end
   return
elseif isstruct(l)	% do time computation:
   n=strfind(f,'.');	% find '.' in filename f
   w=(eval(f(n(end-1)+1:n(end)-1))-1)*l.tstep*l.dt;
   return
end
if nargin<3|isempty(m)
   m=l;
end
if nargin<4|isempty(n)
   n=1;
end
if lmn-l*m*n*nb
   error('There are %d %d-byte floats for array size %d*%d*%d',lmn,nb,l,m,n)
end
w=reshape(fread(fid,[l m*n],'float32'),l,m,n);
status=fclose(fid);
if status
   error('hd3Dinpu(fclose): status=%d',status)
end
