function many2mat(filepat,istride)
%
% many2mat(filepat,istride);
%
% Given filepat, a string with a file specification
% pattern (including path and * wildcards) like 'ABC*xy.z',
% archive all matching files to a single file 'arABC.mat';
% that is, 'ar' is prepended and the extension after the last '*' is replaced by 'mat'.
% It's assumed that the filepat files contain usual
% [fileinfo elems u] type data.
% Files are looped from the first on up with stride istride (default 1).
%
if nargin<2
   istride=1;
end
files=dir(filepat);			% get output filenames
lt=length(files);			% length of time list
if lt<2
   error(sprintf('makes no sense to archive lt=%d files',lt))
end
n=floor((lt-1)/istride)+1;		% no. files
warning('many2mat:nread',sprintf('will read %d files',n))
l=max(strfind(filepat,'/'));		% isolate directory path
k=1;
b=0;
for j=1:istride:lt			% loop over files
   filename=[filepat(1:l) files(j).name];
   [fileinfo(k) elems(k) u(k)]=gbin_input(filename);
   b=overWrite(b,sprintf('many2mat: %4.0f%% done at %s',100*j/n,filename))
   k=k+1;
end
m=max(strfind(filepat,'*'))-1;
eval(['save ar' filepat(l+1:m) '.mat fileinfo elems u files istride'])
